/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.server.file.HttpVfs;
import java.time.Clock;
import java.util.Objects;

public final class HttpFileServiceConfig {
    private final HttpVfs vfs;
    private final Clock clock;
    private final int maxCacheEntries;
    private final int maxCacheEntrySizeBytes;
    private final boolean serveCompressedFiles;

    HttpFileServiceConfig(HttpVfs vfs, Clock clock, int maxCacheEntries, int maxCacheEntrySizeBytes, boolean serveCompressedFiles) {
        this.vfs = Objects.requireNonNull(vfs, "vfs");
        this.clock = Objects.requireNonNull(clock, "clock");
        this.maxCacheEntries = HttpFileServiceConfig.validateMaxCacheEntries(maxCacheEntries);
        this.maxCacheEntrySizeBytes = HttpFileServiceConfig.validateMaxCacheEntrySizeBytes(maxCacheEntrySizeBytes);
        this.serveCompressedFiles = serveCompressedFiles;
    }

    static int validateMaxCacheEntries(int maxCacheEntries) {
        return HttpFileServiceConfig.validateNonNegativeParameter(maxCacheEntries, "maxCacheEntries");
    }

    static int validateMaxCacheEntrySizeBytes(int maxCacheEntrySizeBytes) {
        return HttpFileServiceConfig.validateNonNegativeParameter(maxCacheEntrySizeBytes, "maxCacheEntrySizeBytes");
    }

    private static int validateNonNegativeParameter(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + ": " + value + " (expected: >= 0)");
        }
        return value;
    }

    public HttpVfs vfs() {
        return this.vfs;
    }

    public Clock clock() {
        return this.clock;
    }

    public int maxCacheEntries() {
        return this.maxCacheEntries;
    }

    public int maxCacheEntrySizeBytes() {
        return this.maxCacheEntrySizeBytes;
    }

    public boolean serveCompressedFiles() {
        return this.serveCompressedFiles;
    }

    public String toString() {
        return HttpFileServiceConfig.toString(this, this.vfs(), this.clock(), this.maxCacheEntries(), this.maxCacheEntrySizeBytes());
    }

    static String toString(Object holder, HttpVfs vfs, Clock clock, int maxCacheEntries, int maxCacheEntrySizeBytes) {
        return holder.getClass().getSimpleName() + "(vfs: " + vfs + ", clock: " + clock + ", maxCacheEntries: " + maxCacheEntries + ", maxCacheEntrySizeBytes: " + maxCacheEntrySizeBytes + ')';
    }
}

