/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.file.ClassPathHttpVfs;
import com.linecorp.armeria.server.file.FileSystemHttpVfs;
import com.linecorp.armeria.server.file.MimeTypeUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public interface HttpVfs {
    public static HttpVfs ofFileSystem(String rootDir) {
        return new FileSystemHttpVfs(Paths.get(Objects.requireNonNull(rootDir, "rootDir"), new String[0]));
    }

    public static HttpVfs ofFileSystem(Path rootDir) {
        return new FileSystemHttpVfs(rootDir);
    }

    public static HttpVfs ofClassPath(String rootDir) {
        return HttpVfs.ofClassPath(HttpVfs.class.getClassLoader(), rootDir);
    }

    public static HttpVfs ofClassPath(ClassLoader classLoader, String rootDir) {
        return new ClassPathHttpVfs(classLoader, rootDir);
    }

    public Entry get(String var1, @Nullable String var2);

    public String meterTag();

    public static final class ByteArrayEntry
    extends AbstractEntry {
        private final long lastModifiedMillis;
        private final HttpData content;

        public ByteArrayEntry(String path, byte[] content) {
            this(path, content, System.currentTimeMillis());
        }

        public ByteArrayEntry(String path, byte[] content, long lastModifiedMillis) {
            super(path, null);
            this.content = HttpData.of(Objects.requireNonNull(content, "content"));
            this.lastModifiedMillis = lastModifiedMillis;
        }

        public ByteArrayEntry(String path, MediaType mediaType, byte[] content) {
            this(path, mediaType, content, System.currentTimeMillis());
        }

        public ByteArrayEntry(String path, MediaType mediaType, byte[] content, long lastModifiedMillis) {
            super(path, mediaType, null);
            this.content = HttpData.of(Objects.requireNonNull(content, "content"));
            this.lastModifiedMillis = lastModifiedMillis;
        }

        @Override
        public long lastModifiedMillis() {
            return this.lastModifiedMillis;
        }

        @Override
        public HttpData readContent() {
            return this.content;
        }
    }

    public static abstract class AbstractEntry
    implements Entry {
        private final String path;
        @Nullable
        private final MediaType mediaType;
        @Nullable
        private final String contentEncoding;

        protected AbstractEntry(String path, @Nullable String contentEncoding) {
            this(path, MimeTypeUtil.guessFromPath(path, contentEncoding != null), contentEncoding);
        }

        protected AbstractEntry(String path, @Nullable MediaType mediaType, @Nullable String contentEncoding) {
            this.path = Objects.requireNonNull(path, "path");
            this.mediaType = mediaType;
            this.contentEncoding = contentEncoding;
        }

        @Override
        @Nullable
        public MediaType mediaType() {
            return this.mediaType;
        }

        @Override
        @Nullable
        public String contentEncoding() {
            return this.contentEncoding;
        }

        public String toString() {
            return this.path;
        }

        protected HttpData readContent(InputStream in) throws IOException {
            int readBytes;
            byte[] buf = new byte[Math.max(in.available(), 1024)];
            int endOffset = 0;
            while ((readBytes = in.read(buf, endOffset, buf.length - endOffset)) >= 0) {
                if ((endOffset += readBytes) != buf.length) continue;
                buf = Arrays.copyOf(buf, buf.length << 1);
            }
            return endOffset != 0 ? HttpData.of(buf, 0, endOffset) : HttpData.EMPTY_DATA;
        }

        protected HttpData readContent(InputStream in, int length) throws IOException {
            int readBytes;
            if (length == 0) {
                return HttpData.EMPTY_DATA;
            }
            byte[] buf = new byte[length];
            int endOffset = 0;
            while ((readBytes = in.read(buf, endOffset, buf.length - endOffset)) >= 0 && (endOffset += readBytes) != buf.length) {
            }
            return HttpData.of(buf, 0, endOffset);
        }
    }

    public static interface Entry {
        public static final Entry NONE = new Entry(){

            @Override
            public MediaType mediaType() {
                throw new IllegalStateException();
            }

            @Override
            @Nullable
            public String contentEncoding() {
                return null;
            }

            @Override
            public long lastModifiedMillis() {
                return 0L;
            }

            @Override
            public HttpData readContent() throws IOException {
                throw new FileNotFoundException();
            }

            public String toString() {
                return "none";
            }
        };

        @Nullable
        public MediaType mediaType();

        @Nullable
        public String contentEncoding();

        public long lastModifiedMillis();

        public HttpData readContent() throws IOException;
    }
}

