/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class MimeTypeUtil {
    private static final Map<String, MediaType> EXTENSION_TO_MEDIA_TYPE;

    private static void add(Map<String, MediaType> extensionToMediaType, MediaType mediaType, String ... extensions) {
        for (String e : extensions) {
            assert (Ascii.toLowerCase(e).equals(e));
            extensionToMediaType.put(e, mediaType);
        }
    }

    @Nullable
    static MediaType guessFromPath(String path, boolean preCompressed) {
        Objects.requireNonNull(path, "path");
        if (preCompressed) {
            path = path.substring(0, path.lastIndexOf(46));
        }
        int dotIdx = path.lastIndexOf(46);
        int slashIdx = path.lastIndexOf(47);
        if (dotIdx < 0 || slashIdx > dotIdx) {
            return null;
        }
        String extension = Ascii.toLowerCase(path.substring(dotIdx + 1));
        MediaType mediaType = EXTENSION_TO_MEDIA_TYPE.get(extension);
        if (mediaType != null) {
            return mediaType;
        }
        String guessedContentType = URLConnection.guessContentTypeFromName(path);
        return guessedContentType != null ? MediaType.parse(guessedContentType) : null;
    }

    private MimeTypeUtil() {
    }

    static {
        HashMap<String, MediaType> map = new HashMap<String, MediaType>();
        MimeTypeUtil.add(map, MediaType.CSS_UTF_8, "css");
        MimeTypeUtil.add(map, MediaType.HTML_UTF_8, "html", "htm");
        MimeTypeUtil.add(map, MediaType.PLAIN_TEXT_UTF_8, "txt");
        MimeTypeUtil.add(map, MediaType.GIF, "gif");
        MimeTypeUtil.add(map, MediaType.JPEG, "jpeg", "jpg");
        MimeTypeUtil.add(map, MediaType.PNG, "png");
        MimeTypeUtil.add(map, MediaType.SVG_UTF_8, "svg", "svgz");
        MimeTypeUtil.add(map, MediaType.create("image", "x-icon"), "ico");
        MimeTypeUtil.add(map, MediaType.create("application", "x-font-ttf"), "ttc", "ttf");
        MimeTypeUtil.add(map, MediaType.WOFF, "woff");
        MimeTypeUtil.add(map, MediaType.create("application", "font-woff2"), "woff2");
        MimeTypeUtil.add(map, MediaType.EOT, "eot");
        MimeTypeUtil.add(map, MediaType.create("font", "opentype"), "otf");
        MimeTypeUtil.add(map, MediaType.JAVASCRIPT_UTF_8, "js");
        MimeTypeUtil.add(map, MediaType.JSON_UTF_8, "json");
        MimeTypeUtil.add(map, MediaType.PDF, "pdf");
        MimeTypeUtil.add(map, MediaType.XHTML_UTF_8, "xhtml", "xhtm");
        MimeTypeUtil.add(map, MediaType.APPLICATION_XML_UTF_8, "xml", "xsd");
        MimeTypeUtil.add(map, MediaType.create("application", "xml-dtd"), "dtd");
        EXTENSION_TO_MEDIA_TYPE = Collections.unmodifiableMap(map);
    }
}

