/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.healthcheck;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.ServerListenerAdapter;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.TransientService;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.server.healthcheck.SettableHealthChecker;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class HttpHealthCheckService
extends AbstractHttpService
implements TransientService<HttpRequest, HttpResponse> {
    private static final HttpData RES_OK = HttpData.ofUtf8("ok");
    private static final HttpData RES_NOT_OK = HttpData.ofUtf8("not ok");
    private final List<HealthChecker> healthCheckers;
    private final ServerListener serverHealthUpdater;
    final SettableHealthChecker serverHealth;
    @Nullable
    private Server server;

    public HttpHealthCheckService(HealthChecker ... healthCheckers) {
        this(ImmutableList.copyOf(Objects.requireNonNull(healthCheckers, "healthCheckers")));
    }

    public HttpHealthCheckService(Iterable<? extends HealthChecker> healthCheckers) {
        this.healthCheckers = ImmutableList.copyOf(Objects.requireNonNull(healthCheckers, "healthCheckers"));
        this.serverHealth = new SettableHealthChecker();
        this.serverHealthUpdater = new ServerHealthUpdater();
    }

    protected AggregatedHttpMessage newHealthyResponse(ServiceRequestContext ctx) {
        return AggregatedHttpMessage.of(HttpStatus.OK, MediaType.PLAIN_TEXT_UTF_8, RES_OK);
    }

    protected AggregatedHttpMessage newUnhealthyResponse(ServiceRequestContext ctx) {
        return AggregatedHttpMessage.of(HttpStatus.SERVICE_UNAVAILABLE, MediaType.PLAIN_TEXT_UTF_8, RES_NOT_OK);
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        super.serviceAdded(cfg);
        if (this.server != null) {
            if (this.server != cfg.server()) {
                throw new IllegalStateException("cannot be added to more than one server");
            }
            return;
        }
        this.server = cfg.server();
        this.server.addListener(this.serverHealthUpdater);
    }

    @Override
    protected HttpResponse doHead(ServiceRequestContext ctx, HttpRequest req) {
        return HttpResponse.of(this.newResponse(ctx).headers());
    }

    @Override
    protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) {
        return HttpResponse.of(this.newResponse(ctx));
    }

    private AggregatedHttpMessage newResponse(ServiceRequestContext ctx) {
        return this.isHealthy() ? this.newHealthyResponse(ctx) : this.newUnhealthyResponse(ctx);
    }

    private boolean isHealthy() {
        for (HealthChecker healthChecker : this.healthCheckers) {
            if (healthChecker.isHealthy()) continue;
            return false;
        }
        return this.serverHealth.isHealthy();
    }

    final class ServerHealthUpdater
    extends ServerListenerAdapter {
        ServerHealthUpdater() {
        }

        @Override
        public void serverStarted(Server server) {
            HttpHealthCheckService.this.serverHealth.setHealthy(true);
        }

        @Override
        public void serverStopping(Server server) {
            HttpHealthCheckService.this.serverHealth.setHealthy(false);
        }
    }
}

