/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.healthcheck;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.server.healthcheck.HttpHealthCheckService;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class ManagedHttpHealthCheckService
extends HttpHealthCheckService {
    private static final AggregatedHttpMessage TURN_ON_RES = AggregatedHttpMessage.of(HttpStatus.OK, MediaType.PLAIN_TEXT_UTF_8, HttpData.ofUtf8("Set healthy."));
    private static final AggregatedHttpMessage TURN_OFF_RES = AggregatedHttpMessage.of(HttpStatus.OK, MediaType.PLAIN_TEXT_UTF_8, HttpData.ofUtf8("Set unhealthy."));
    private static final AggregatedHttpMessage BAD_REQUEST_RES = AggregatedHttpMessage.of(HttpStatus.BAD_REQUEST, MediaType.PLAIN_TEXT_UTF_8, HttpData.ofUtf8("Not supported."));

    public ManagedHttpHealthCheckService() {
        super(new HealthChecker[0]);
    }

    @Override
    protected HttpResponse doPut(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.from(this.updateHealthStatus(ctx, req).thenApply(HttpResponse::of).exceptionally(HttpResponse::ofFailure));
    }

    private CompletionStage<AggregatedHttpMessage> updateHealthStatus(ServiceRequestContext ctx, HttpRequest req) {
        return this.mode(ctx, req).thenApply(mode -> {
            if (!mode.isPresent()) {
                return BAD_REQUEST_RES;
            }
            boolean isHealthy = (Boolean)mode.get();
            this.serverHealth.setHealthy(isHealthy);
            return isHealthy ? TURN_ON_RES : TURN_OFF_RES;
        });
    }

    protected CompletionStage<Optional<Boolean>> mode(ServiceRequestContext ctx, HttpRequest req) {
        return ((CompletableFuture)((CompletableFuture)req.aggregate().thenApply(AggregatedHttpMessage::content)).thenApply(HttpData::toStringAscii)).thenApply(content -> {
            switch (Ascii.toUpperCase(content)) {
                case "ON": {
                    return Optional.of(true);
                }
                case "OFF": {
                    return Optional.of(false);
                }
            }
            return Optional.empty();
        });
    }
}

