/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import com.linecorp.armeria.server.logging.AccessLogType;
import io.netty.util.AsciiString;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@FunctionalInterface
interface AccessLogComponent {
    @Nullable
    public Object getMessage(RequestLog var1);

    default public boolean addQuote() {
        return false;
    }

    public static AccessLogComponent ofText(String text) {
        return new TextComponent(text);
    }

    public static AccessLogComponent ofDefaultRequestTimestamp() {
        return new TimestampComponent(false, null);
    }

    public static AccessLogComponent ofPredefinedCommon(AccessLogType type) {
        return new CommonComponent(type, type == AccessLogType.REQUEST_LINE, null);
    }

    public static AccessLogComponent ofQuotedRequestHeader(AsciiString headerName) {
        return new HttpHeaderComponent(AccessLogType.REQUEST_HEADER, headerName, true, null);
    }

    public static class RequestLogComponent
    extends ResponseHeaderConditional {
        private final Function<RequestLog, Object> resolver;

        static boolean isSupported(AccessLogType type) {
            return type == AccessLogType.REQUEST_LOG;
        }

        RequestLogComponent(String variable, boolean addQuote, @Nullable Function<HttpHeaders, Boolean> condition) {
            super(condition, addQuote);
            this.resolver = RequestLogComponent.findResolver(Objects.requireNonNull(variable, "variable"));
        }

        @Override
        @Nullable
        Object getMessage0(RequestLog log) {
            return this.resolver.apply(log);
        }

        @Nullable
        private static String handleThrowable(@Nullable Throwable cause) {
            if (cause == null) {
                return null;
            }
            String message = (cause = Exceptions.peel(cause)).getMessage();
            return message != null ? cause.getClass().getSimpleName() + ": " + message : cause.getClass().getSimpleName();
        }

        private static Function<RequestLog, Object> findResolver(String variable) {
            switch (variable) {
                case "method": {
                    return RequestLog::method;
                }
                case "path": {
                    return RequestLog::path;
                }
                case "query": {
                    return RequestLog::query;
                }
                case "requestStartTimeMillis": {
                    return RequestLog::requestStartTimeMillis;
                }
                case "requestEndTimeMillis": {
                    return log -> Instant.ofEpochMilli(log.requestStartTimeMillis()).plusNanos(log.requestDurationNanos()).toEpochMilli();
                }
                case "requestDurationMillis": {
                    return log -> Duration.ofNanos(log.requestDurationNanos()).toMillis();
                }
                case "requestDurationNanos": {
                    return RequestLog::requestDurationNanos;
                }
                case "requestLength": {
                    return RequestLog::requestLength;
                }
                case "requestCause": {
                    return log -> RequestLogComponent.handleThrowable(log.requestCause());
                }
                case "responseStartTimeMillis": {
                    return RequestLog::responseStartTimeMillis;
                }
                case "responseEndTimeMillis": {
                    return log -> Instant.ofEpochMilli(log.responseStartTimeMillis()).plusNanos(log.responseDurationNanos()).toEpochMilli();
                }
                case "responseDurationMillis": {
                    return log -> Duration.ofNanos(log.responseDurationNanos()).toMillis();
                }
                case "responseDurationNanos": {
                    return RequestLog::responseDurationNanos;
                }
                case "responseLength": {
                    return RequestLog::responseLength;
                }
                case "responseCause": {
                    return log -> RequestLogComponent.handleThrowable(log.responseCause());
                }
                case "totalDurationMillis": {
                    return log -> Duration.ofNanos(log.totalDurationNanos()).toMillis();
                }
                case "totalDurationNanos": {
                    return RequestLog::totalDurationNanos;
                }
                case "sessionProtocol": {
                    return RequestLog::sessionProtocol;
                }
                case "serializationFormat": {
                    return RequestLog::serializationFormat;
                }
                case "scheme": {
                    return RequestLog::scheme;
                }
                case "host": {
                    return log -> {
                        String authority = log.responseHeaders().authority();
                        if ("?".equals(authority)) {
                            InetSocketAddress remoteAddr = (InetSocketAddress)log.context().remoteAddress();
                            assert (remoteAddr != null);
                            return remoteAddr.getHostString();
                        }
                        return authority;
                    };
                }
                case "status": {
                    return RequestLog::status;
                }
                case "statusCode": {
                    return RequestLog::statusCode;
                }
            }
            throw new IllegalArgumentException("unexpected request log variable: " + variable);
        }
    }

    public static class AttributeComponent
    extends ResponseHeaderConditional {
        private final AttributeKey<?> key;
        private final Function<Object, String> stringifer;

        static boolean isSupported(AccessLogType type) {
            return type == AccessLogType.ATTRIBUTE;
        }

        AttributeComponent(String attributeName, Function<Object, String> stringifer, boolean addQuote, @Nullable Function<HttpHeaders, Boolean> condition) {
            super(condition, addQuote);
            this.key = AttributeKey.valueOf((String)Objects.requireNonNull(attributeName, "attributeName"));
            this.stringifer = Objects.requireNonNull(stringifer, "stringifer");
        }

        AttributeKey<?> key() {
            return this.key;
        }

        @Override
        @Nullable
        Object getMessage0(RequestLog log) {
            Attribute value = log.context().attr(this.key);
            return value != null ? this.stringifer.apply(value.get()) : null;
        }
    }

    public static class HttpHeaderComponent
    extends ResponseHeaderConditional {
        private final AsciiString headerName;
        private final Function<RequestLog, HttpHeaders> httpHeaders;

        static boolean isSupported(AccessLogType type) {
            return type == AccessLogType.REQUEST_HEADER || type == AccessLogType.RESPONSE_HEADER;
        }

        HttpHeaderComponent(AccessLogType logType, AsciiString headerName, boolean addQuote, @Nullable Function<HttpHeaders, Boolean> condition) {
            super(condition, addQuote);
            this.headerName = Objects.requireNonNull(headerName, "headerName");
            if (logType == AccessLogType.REQUEST_HEADER) {
                this.httpHeaders = RequestLog::requestHeaders;
            } else {
                assert (logType == AccessLogType.RESPONSE_HEADER) : logType.name();
                this.httpHeaders = RequestLog::responseHeaders;
            }
        }

        AsciiString headerName() {
            return this.headerName;
        }

        @Override
        public Object getMessage0(RequestLog log) {
            return this.httpHeaders.apply(log).get(this.headerName);
        }
    }

    public static class CommonComponent
    extends ResponseHeaderConditional {
        private final AccessLogType type;

        static boolean isSupported(AccessLogType type) {
            switch (type) {
                case REMOTE_HOST: 
                case RFC931: 
                case AUTHENTICATED_USER: 
                case REQUEST_LINE: 
                case RESPONSE_STATUS_CODE: 
                case RESPONSE_LENGTH: {
                    return true;
                }
            }
            return false;
        }

        CommonComponent(AccessLogType type, boolean addQuote, @Nullable Function<HttpHeaders, Boolean> condition) {
            super(condition, addQuote);
            Preconditions.checkArgument(CommonComponent.isSupported(Objects.requireNonNull(type, "type")), "Type '" + (Object)((Object)type) + "' is not acceptable by " + CommonComponent.class.getName());
            this.type = type;
        }

        @Override
        @Nullable
        public Object getMessage0(RequestLog log) {
            switch (this.type) {
                case REMOTE_HOST: {
                    Object ra = log.context().remoteAddress();
                    return ra instanceof InetSocketAddress ? ((InetSocketAddress)ra).getHostString() : null;
                }
                case RFC931: 
                case AUTHENTICATED_USER: {
                    return null;
                }
                case REQUEST_LINE: {
                    StringBuilder requestLine = new StringBuilder();
                    requestLine.append((Object)log.method()).append(' ').append(log.requestHeaders().path());
                    Object requestContent = log.requestContent();
                    if (requestContent instanceof RpcRequest) {
                        requestLine.append('#').append(((RpcRequest)requestContent).method());
                    }
                    requestLine.append(' ').append(MoreObjects.firstNonNull(log.sessionProtocol(), log.context().sessionProtocol()).uriText());
                    return requestLine.toString();
                }
                case RESPONSE_STATUS_CODE: {
                    return log.statusCode();
                }
                case RESPONSE_LENGTH: {
                    return log.responseLength();
                }
            }
            return null;
        }
    }

    public static abstract class ResponseHeaderConditional
    implements AccessLogComponent {
        @Nullable
        private final Function<HttpHeaders, Boolean> condition;
        private final boolean addQuote;

        protected ResponseHeaderConditional(@Nullable Function<HttpHeaders, Boolean> condition, boolean addQuote) {
            this.condition = condition;
            this.addQuote = addQuote;
        }

        @Nullable
        Function<HttpHeaders, Boolean> condition() {
            return this.condition;
        }

        @Override
        @Nullable
        public final Object getMessage(RequestLog log) {
            if (this.condition != null && !this.condition.apply(log.responseHeaders()).booleanValue()) {
                return null;
            }
            return this.getMessage0(log);
        }

        @Nullable
        abstract Object getMessage0(RequestLog var1);

        @Override
        public boolean addQuote() {
            return this.addQuote;
        }
    }

    public static class TimestampComponent
    implements AccessLogComponent {
        static final DateTimeFormatter defaultDateTimeFormatter = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z", Locale.ENGLISH);
        static final ZoneId defaultZoneId = ZoneId.systemDefault();
        private static final Map<String, DateTimeFormatter> predefinedFormatters = ReflectionUtils.getFields(DateTimeFormatter.class, field -> {
            int m = field.getModifiers();
            return Modifier.isPublic(m) && Modifier.isStatic(m) && Modifier.isFinal(m) && field.getType() == DateTimeFormatter.class;
        }).stream().collect(Collectors.toMap(Field::getName, f -> {
            try {
                return (DateTimeFormatter)f.get(null);
            }
            catch (Throwable cause) {
                throw new Error(cause);
            }
        }));
        private final boolean addQuote;
        private final DateTimeFormatter formatter;

        static boolean isSupported(AccessLogType type) {
            return type == AccessLogType.REQUEST_TIMESTAMP;
        }

        TimestampComponent(boolean addQuote, @Nullable String variable) {
            this.addQuote = addQuote;
            this.formatter = TimestampComponent.findFormatter(variable);
        }

        @Override
        @Nullable
        public Object getMessage(RequestLog log) {
            return this.formatter.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(log.requestStartTimeMillis()), defaultZoneId));
        }

        @Override
        public boolean addQuote() {
            return this.addQuote;
        }

        static DateTimeFormatter findFormatter(@Nullable String variable) {
            if (variable == null) {
                return defaultDateTimeFormatter;
            }
            DateTimeFormatter predefined = predefinedFormatters.get(variable);
            if (predefined != null) {
                return predefined;
            }
            try {
                return DateTimeFormatter.ofPattern(variable, Locale.ENGLISH);
            }
            catch (Throwable cause) {
                throw new IllegalArgumentException("unexpected date/time format variable: " + variable, cause);
            }
        }
    }

    public static class TextComponent
    implements AccessLogComponent {
        private final String text;

        static boolean isSupported(AccessLogType type) {
            return type == AccessLogType.TEXT;
        }

        TextComponent(String text) {
            this.text = Objects.requireNonNull(text, "text");
        }

        @Override
        public Object getMessage(RequestLog log) {
            return this.text;
        }
    }
}

