/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.logging;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.logging.AccessLogComponent;
import com.linecorp.armeria.server.logging.AccessLogType;
import io.netty.util.AsciiString;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

final class AccessLogFormats {
    private static final AccessLogComponent BLANK = AccessLogComponent.ofText(" ");
    static final List<AccessLogComponent> COMMON = ImmutableList.of(AccessLogComponent.ofPredefinedCommon(AccessLogType.REMOTE_HOST), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.RFC931), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.AUTHENTICATED_USER), BLANK, AccessLogComponent.ofDefaultRequestTimestamp(), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.REQUEST_LINE), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.RESPONSE_STATUS_CODE), BLANK, new AccessLogComponent[]{AccessLogComponent.ofPredefinedCommon(AccessLogType.RESPONSE_LENGTH)});
    static final List<AccessLogComponent> COMBINED = ImmutableList.of(AccessLogComponent.ofPredefinedCommon(AccessLogType.REMOTE_HOST), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.RFC931), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.AUTHENTICATED_USER), BLANK, AccessLogComponent.ofDefaultRequestTimestamp(), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.REQUEST_LINE), BLANK, AccessLogComponent.ofPredefinedCommon(AccessLogType.RESPONSE_STATUS_CODE), BLANK, new AccessLogComponent[]{AccessLogComponent.ofPredefinedCommon(AccessLogType.RESPONSE_LENGTH), BLANK, AccessLogComponent.ofQuotedRequestHeader(HttpHeaderNames.REFERER), BLANK, AccessLogComponent.ofQuotedRequestHeader(HttpHeaderNames.USER_AGENT), BLANK, AccessLogComponent.ofQuotedRequestHeader(HttpHeaderNames.COOKIE)});

    static List<AccessLogComponent> parseCustom(String formatStr) {
        Objects.requireNonNull(formatStr, "formatStr");
        ImmutableList.Builder builder = ImmutableList.builder();
        StringBuilder textBuilder = new StringBuilder();
        Condition.Builder condBuilder = null;
        String variable = null;
        State state = State.TEXT;
        int i = 0;
        block7: while (i < formatStr.length()) {
            char ch = formatStr.charAt(i);
            switch (state) {
                case TEXT: {
                    if (ch == '%') {
                        if (textBuilder.length() > 0) {
                            builder.add(AccessLogComponent.ofText(AccessLogFormats.newStringAndReset(textBuilder)));
                        }
                        condBuilder = null;
                        variable = null;
                        state = State.PERCENT;
                        break;
                    }
                    textBuilder.append(ch);
                    break;
                }
                case PERCENT: {
                    if (Character.isAlphabetic(ch)) {
                        state = State.TOKEN;
                        continue block7;
                    }
                    if (Character.isDigit(ch)) {
                        condBuilder = Condition.builder();
                        state = State.CONDITION;
                        continue block7;
                    }
                    if (ch == '!') {
                        condBuilder = Condition.builder().setSign(false);
                        state = State.CONDITION;
                        break;
                    }
                    if (ch != '{') break;
                    state = State.VARIABLE;
                    break;
                }
                case CONDITION: {
                    if (Character.isDigit(ch)) {
                        textBuilder.append(ch);
                        break;
                    }
                    if (textBuilder.length() > 0) {
                        condBuilder.addHttpStatus(AccessLogFormats.newStringAndReset(textBuilder));
                    }
                    if (Character.isAlphabetic(ch)) {
                        state = State.TOKEN;
                        continue block7;
                    }
                    if (ch == '{') {
                        state = State.VARIABLE;
                        break;
                    }
                    if (ch == ',') break;
                    throw new IllegalArgumentException("Unexpected character in condition:" + ch);
                }
                case VARIABLE: {
                    if (ch != '}') {
                        textBuilder.append(ch);
                        break;
                    }
                    if (textBuilder.length() > 0) {
                        variable = AccessLogFormats.newStringAndReset(textBuilder);
                    }
                    state = State.TOKEN;
                    break;
                }
                case TOKEN: {
                    builder.add(AccessLogFormats.newAccessLogComponent(ch, variable, condBuilder));
                    state = State.TEXT;
                }
            }
            ++i;
        }
        if (state != State.TEXT) {
            throw new IllegalArgumentException("Unexpected access log format: " + formatStr);
        }
        if (textBuilder.length() > 0) {
            builder.add(AccessLogComponent.ofText(AccessLogFormats.newStringAndReset(textBuilder)));
        }
        return builder.build();
    }

    private static AccessLogComponent newAccessLogComponent(char token, @Nullable String variable, @Nullable Condition.Builder condBuilder) {
        Function<HttpHeaders, Boolean> condition;
        AccessLogType type = AccessLogType.find(token).orElseThrow(() -> new IllegalArgumentException("Unexpected token character: '" + token + '\''));
        if (type.variableRequirement() == AccessLogType.VariableRequirement.YES) {
            Preconditions.checkArgument(variable != null, "Token " + type.token() + " requires a variable.");
        }
        if (type.isConditionAvailable()) {
            if (condBuilder != null) {
                Preconditions.checkArgument(!condBuilder.isEmpty(), "Token " + type.token() + " has an invalid condition.");
            }
        } else {
            Preconditions.checkArgument(condBuilder == null, "Token " + type.token() + " does not support a condition.");
        }
        if (AccessLogComponent.TextComponent.isSupported(type)) {
            assert (variable != null);
            return AccessLogComponent.ofText(variable);
        }
        boolean addQuote = false;
        Function<HttpHeaders, Boolean> function = condition = condBuilder != null ? condBuilder.build() : null;
        if (AccessLogComponent.TimestampComponent.isSupported(type)) {
            return new AccessLogComponent.TimestampComponent(false, variable);
        }
        if (AccessLogComponent.CommonComponent.isSupported(type)) {
            return new AccessLogComponent.CommonComponent(type, false, condition);
        }
        if (AccessLogComponent.HttpHeaderComponent.isSupported(type)) {
            assert (variable != null);
            return new AccessLogComponent.HttpHeaderComponent(type, AsciiString.of((CharSequence)variable), false, condition);
        }
        if (AccessLogComponent.AttributeComponent.isSupported(type)) {
            assert (variable != null);
            String[] components = variable.split(":");
            Function<Object, String> stringifier = components.length == 2 ? AccessLogFormats.newStringifier(components[0], components[1]) : Object::toString;
            return new AccessLogComponent.AttributeComponent(components[0], stringifier, false, condition);
        }
        if (AccessLogComponent.RequestLogComponent.isSupported(type)) {
            assert (variable != null);
            return new AccessLogComponent.RequestLogComponent(variable, false, condition);
        }
        throw new Error("Unexpected access log type: " + type.name());
    }

    private static String newStringAndReset(StringBuilder textBuilder) {
        String str = textBuilder.toString();
        textBuilder.setLength(0);
        return str;
    }

    private static Function<Object, String> newStringifier(String attrName, String className) {
        Function stringifier;
        try {
            stringifier = (Function)Class.forName(className, true, AccessLogFormats.class.getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to instantiate a stringifier function: " + attrName, e);
        }
        return stringifier;
    }

    private AccessLogFormats() {
    }

    private static enum State {
        TEXT,
        PERCENT,
        CONDITION,
        VARIABLE,
        TOKEN;

    }

    private static final class Condition
    implements Function<HttpHeaders, Boolean> {
        private final Set<HttpStatus> statusSet;
        private final boolean sign;

        Condition(Set<HttpStatus> statusSet, boolean sign) {
            this.statusSet = statusSet;
            this.sign = sign;
        }

        public Set<HttpStatus> statusSet() {
            return this.statusSet;
        }

        public boolean isSign() {
            return this.sign;
        }

        @Override
        public Boolean apply(HttpHeaders headers) {
            return this.statusSet.contains(headers.status()) == this.sign;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("sign", this.isSign()).add("statusSet", this.statusSet()).toString();
        }

        static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private final ImmutableSet.Builder<HttpStatus> statusSet = ImmutableSet.builder();
            private boolean sign = true;
            private boolean isEmpty = true;

            Builder() {
            }

            Builder setSign(boolean sign) {
                this.sign = sign;
                return this;
            }

            Builder addHttpStatus(String text) {
                HttpStatus s = HttpStatus.valueOf(Integer.valueOf(text));
                this.statusSet.add((Object)s);
                this.isEmpty = false;
                return this;
            }

            boolean isEmpty() {
                return this.isEmpty;
            }

            Function<HttpHeaders, Boolean> build() {
                return new Condition(this.statusSet.build(), this.sign);
            }
        }
    }
}

