/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.logging.LoggingDecorators;
import com.linecorp.armeria.internal.logging.Sampler;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingService;
import com.linecorp.armeria.server.logging.LoggingServiceBuilder;
import java.util.Objects;
import java.util.function.Function;

public final class LoggingService<I extends Request, O extends Response>
extends SimpleDecoratingService<I, O> {
    private final LogLevel requestLogLevel;
    private final LogLevel successfulResponseLogLevel;
    private final LogLevel failedResponseLogLevel;
    private final Function<HttpHeaders, HttpHeaders> requestHeadersSanitizer;
    private final Function<Object, Object> requestContentSanitizer;
    private final Function<HttpHeaders, HttpHeaders> responseHeadersSanitizer;
    private final Function<Object, Object> responseContentSanitizer;
    private final Sampler sampler;

    public static <I extends Request, O extends Response> Function<Service<I, O>, LoggingService<I, O>> newDecorator() {
        return ((LoggingServiceBuilder)((LoggingServiceBuilder)((LoggingServiceBuilder)new LoggingServiceBuilder().requestLogLevel(LogLevel.INFO)).successfulResponseLogLevel(LogLevel.INFO)).failureResponseLogLevel(LogLevel.WARN)).newDecorator();
    }

    @Deprecated
    public static <I extends Request, O extends Response> Function<Service<I, O>, LoggingService<I, O>> newDecorator(LogLevel level) {
        return delegate -> new LoggingService(delegate, level);
    }

    @Deprecated
    public LoggingService(Service<I, O> delegate) {
        this(delegate, LogLevel.INFO);
    }

    @Deprecated
    public LoggingService(Service<I, O> delegate, LogLevel level) {
        this(delegate, level, level, level, Function.identity(), Function.identity(), Function.identity(), Function.identity(), Sampler.always());
    }

    LoggingService(Service<I, O> delegate, LogLevel requestLogLevel, LogLevel successfulResponseLogLevel, LogLevel failedResponseLogLevel, Function<HttpHeaders, HttpHeaders> requestHeadersSanitizer, Function<Object, Object> requestContentSanitizer, Function<HttpHeaders, HttpHeaders> responseHeadersSanitizer, Function<Object, Object> responseContentSanitizer, Sampler sampler) {
        super(Objects.requireNonNull(delegate, "delegate"));
        this.requestLogLevel = Objects.requireNonNull(requestLogLevel, "requestLogLevel");
        this.successfulResponseLogLevel = Objects.requireNonNull(successfulResponseLogLevel, "successfulResponseLogLevel");
        this.failedResponseLogLevel = Objects.requireNonNull(failedResponseLogLevel, "failedResponseLogLevel");
        this.requestHeadersSanitizer = Objects.requireNonNull(requestHeadersSanitizer, "requestHeadersSanitizer");
        this.requestContentSanitizer = Objects.requireNonNull(requestContentSanitizer, "requestContentSanitizer");
        this.responseHeadersSanitizer = Objects.requireNonNull(responseHeadersSanitizer, "responseHeadersSanitizer");
        this.responseContentSanitizer = Objects.requireNonNull(responseContentSanitizer, "resposneContentSanitizer");
        this.sampler = Objects.requireNonNull(sampler, "sampler");
    }

    @Override
    public O serve(ServiceRequestContext ctx, I req) throws Exception {
        if (this.sampler.isSampled()) {
            ctx.log().addListener(log -> LoggingDecorators.logRequest(((ServiceRequestContext)log.context()).logger(), log, this.requestLogLevel, this.requestHeadersSanitizer, this.requestContentSanitizer), RequestLogAvailability.REQUEST_END);
            ctx.log().addListener(log -> LoggingDecorators.logResponse(((ServiceRequestContext)log.context()).logger(), log, this.requestLogLevel, this.requestHeadersSanitizer, this.requestContentSanitizer, this.successfulResponseLogLevel, this.failedResponseLogLevel, this.responseHeadersSanitizer, this.responseContentSanitizer), RequestLogAvailability.COMPLETE);
        }
        return this.delegate().serve(ctx, req);
    }
}

