/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.throttling;

import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.util.concurrent.RateLimiter;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.throttling.ThrottlingStrategy;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;

public final class RateLimitingThrottlingStrategy<T extends Request>
extends ThrottlingStrategy<T> {
    private final RateLimiter rateLimiter;

    public RateLimitingThrottlingStrategy(double requestPerSecond, @Nullable String name) {
        super(name);
        Preconditions.checkArgument(requestPerSecond > 0.0, "requestPerSecond: %s (expected: > 0)", (Object)requestPerSecond);
        this.rateLimiter = RateLimiter.create(requestPerSecond);
    }

    public RateLimitingThrottlingStrategy(double requestPerSecond) {
        this(requestPerSecond, null);
    }

    RateLimitingThrottlingStrategy(RateLimiter rateLimiter) {
        this.rateLimiter = Objects.requireNonNull(rateLimiter, "rateLimiter");
    }

    @Override
    public CompletionStage<Boolean> accept(ServiceRequestContext ctx, T request) {
        return CompletableFuture.completedFuture(this.rateLimiter.tryAcquire());
    }
}

