/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.throttling;

import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingService;
import com.linecorp.armeria.server.throttling.ThrottlingStrategy;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class ThrottlingService<I extends Request, O extends Response>
extends SimpleDecoratingService<I, O> {
    private final ThrottlingStrategy<I> strategy;
    private final Function<CompletionStage<? extends O>, O> responseConverter;

    protected ThrottlingService(Service<I, O> delegate, ThrottlingStrategy<I> strategy, Function<CompletionStage<? extends O>, O> responseConverter) {
        super(delegate);
        this.strategy = Objects.requireNonNull(strategy, "strategy");
        this.responseConverter = Objects.requireNonNull(responseConverter);
    }

    protected O onSuccess(ServiceRequestContext ctx, I req) throws Exception {
        return this.delegate().serve(ctx, req);
    }

    protected abstract O onFailure(ServiceRequestContext var1, I var2, @Nullable Throwable var3) throws Exception;

    @Override
    public O serve(ServiceRequestContext ctx, I req) throws Exception {
        return (O)((Response)this.responseConverter.apply(this.strategy.accept(ctx, req).handleAsync((accept, thrown) -> {
            try {
                if (thrown != null || !accept.booleanValue()) {
                    return this.onFailure(ctx, req, (Throwable)thrown);
                }
                return this.onSuccess(ctx, req);
            }
            catch (Exception e) {
                return (Response)Exceptions.throwUnsafely(e);
            }
        }, (Executor)ctx.contextAwareEventLoop())));
    }
}

