/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.throttling;

import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

public abstract class ThrottlingStrategy<T extends Request> {
    private static final AtomicInteger GLOBAL_STRATEGY_ID = new AtomicInteger();
    private static final ThrottlingStrategy<?> NEVER = new ThrottlingStrategy<Request>("throttling-strategy-never"){

        @Override
        public CompletionStage<Boolean> accept(ServiceRequestContext ctx, Request request) {
            return CompletableFuture.completedFuture(false);
        }
    };
    private static final ThrottlingStrategy<?> ALWAYS = new ThrottlingStrategy<Request>("throttling-strategy-always"){

        @Override
        public CompletionStage<Boolean> accept(ServiceRequestContext ctx, Request request) {
            return CompletableFuture.completedFuture(true);
        }
    };
    private final String name;

    protected ThrottlingStrategy() {
        this(null);
    }

    protected ThrottlingStrategy(@Nullable String name) {
        this.name = name != null ? name : "throttling-strategy-" + (this.getClass().isAnonymousClass() ? Integer.toString(GLOBAL_STRATEGY_ID.getAndIncrement()) : this.getClass().getSimpleName());
    }

    public static <T extends Request> ThrottlingStrategy<T> never() {
        return NEVER;
    }

    public static <T extends Request> ThrottlingStrategy<T> always() {
        return ALWAYS;
    }

    public static <T extends Request> ThrottlingStrategy<T> of(final BiFunction<ServiceRequestContext, T, CompletionStage<Boolean>> function, String strategyName) {
        return new ThrottlingStrategy<T>(strategyName){

            @Override
            public CompletionStage<Boolean> accept(ServiceRequestContext ctx, T request) {
                return (CompletionStage)function.apply(ctx, request);
            }
        };
    }

    public static <T extends Request> ThrottlingStrategy<T> of(final BiFunction<ServiceRequestContext, T, CompletionStage<Boolean>> function) {
        return new ThrottlingStrategy<T>(null){

            @Override
            public CompletionStage<Boolean> accept(ServiceRequestContext ctx, T request) {
                return (CompletionStage)function.apply(ctx, request);
            }
        };
    }

    public abstract CompletionStage<Boolean> accept(ServiceRequestContext var1, T var2);

    public String name() {
        return this.name;
    }
}

