/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.unsafe;

import com.linecorp.armeria.common.AbstractHttpData;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.Objects;

public class ByteBufHttpData
extends AbstractHttpData
implements ByteBufHolder {
    private final ByteBuf buf;
    private final boolean endOfStream;
    private final int length;

    public ByteBufHttpData(ByteBuf buf, boolean endOfStream) {
        this.length = Objects.requireNonNull(buf, "buf").readableBytes();
        if (this.length != 0) {
            this.buf = buf;
        } else {
            buf.release();
            this.buf = Unpooled.EMPTY_BUFFER;
        }
        this.endOfStream = endOfStream;
    }

    @Override
    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    @Override
    public byte[] array() {
        if (this.buf.hasArray()) {
            return this.buf.array();
        }
        return ByteBufUtil.getBytes((ByteBuf)this.buf);
    }

    @Override
    public int offset() {
        return this.buf.hasArray() ? this.buf.arrayOffset() : 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        this.buf.touch();
        return super.isEmpty();
    }

    public int refCnt() {
        return this.buf.refCnt();
    }

    public ByteBufHttpData retain() {
        this.buf.retain();
        return this;
    }

    public ByteBufHttpData retain(int increment) {
        this.buf.retain(increment);
        return this;
    }

    public ByteBufHttpData touch() {
        this.buf.touch();
        return this;
    }

    public ByteBufHttpData touch(Object hint) {
        this.buf.touch(hint);
        return this;
    }

    public boolean release() {
        return this.buf.release();
    }

    public boolean release(int decrement) {
        return this.buf.release(decrement);
    }

    public ByteBuf content() {
        this.buf.touch();
        return this.buf;
    }

    public ByteBufHttpData copy() {
        return new ByteBufHttpData(this.buf.copy(), this.endOfStream);
    }

    public ByteBufHttpData duplicate() {
        return new ByteBufHttpData(this.buf.duplicate(), this.endOfStream);
    }

    public ByteBufHttpData retainedDuplicate() {
        return new ByteBufHttpData(this.buf.retainedDuplicate(), this.endOfStream);
    }

    public ByteBufHttpData replace(ByteBuf content) {
        Objects.requireNonNull(content, "content");
        content.touch();
        return new ByteBufHttpData(content, this.endOfStream);
    }

    @Override
    protected byte getByte(int index) {
        return this.buf.getByte(index);
    }

    @Override
    public String toString(Charset charset) {
        return this.buf.toString(charset);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("buf", this.buf.toString()).toString();
    }
}

