/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.spring;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.spring.ThriftServiceUtils;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.docs.DocServiceBuilder;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.server.healthcheck.HttpHealthCheckService;
import com.linecorp.armeria.server.metric.MetricCollectingService;
import com.linecorp.armeria.server.metric.PrometheusExpositionService;
import com.linecorp.armeria.spring.AbstractServiceRegistrationBean;
import com.linecorp.armeria.spring.AnnotatedServiceRegistrationBean;
import com.linecorp.armeria.spring.ArmeriaSettings;
import com.linecorp.armeria.spring.HttpServiceRegistrationBean;
import com.linecorp.armeria.spring.MeterIdPrefixFunctionFactory;
import com.linecorp.armeria.spring.Ssl;
import com.linecorp.armeria.spring.ThriftServiceRegistrationBean;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.NetUtil;
import io.prometheus.client.CollectorRegistry;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public final class ArmeriaConfigurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaConfigurationUtil.class);
    private static final HealthChecker[] EMPTY_HEALTH_CHECKERS = new HealthChecker[0];
    private static final String METER_TYPE = "server";

    public static void configureServerWithArmeriaSettings(ServerBuilder server, ArmeriaSettings settings, MeterRegistry meterRegistry, List<HealthChecker> healthCheckers) {
        String healthCheckPath;
        Objects.requireNonNull(server, METER_TYPE);
        Objects.requireNonNull(settings, "settings");
        Objects.requireNonNull(meterRegistry, "meterRegistry");
        Objects.requireNonNull(healthCheckers, "healthCheckers");
        if (settings.getGracefulShutdownQuietPeriodMillis() >= 0L && settings.getGracefulShutdownTimeoutMillis() >= 0L) {
            server.gracefulShutdownTimeout(settings.getGracefulShutdownQuietPeriodMillis(), settings.getGracefulShutdownTimeoutMillis());
            logger.debug("Set graceful shutdown timeout: quiet period {} ms, timeout {} ms", (Object)settings.getGracefulShutdownQuietPeriodMillis(), (Object)settings.getGracefulShutdownTimeoutMillis());
        }
        if (!Strings.isNullOrEmpty((String)(healthCheckPath = settings.getHealthCheckPath()))) {
            server.service(healthCheckPath, (Service)new HttpHealthCheckService(healthCheckers.toArray(EMPTY_HEALTH_CHECKERS)));
        }
        server.meterRegistry(meterRegistry);
        if (settings.isEnableMetrics() && !Strings.isNullOrEmpty((String)settings.getMetricsPath())) {
            if (meterRegistry instanceof CompositeMeterRegistry) {
                Set childRegistries = ((CompositeMeterRegistry)meterRegistry).getRegistries();
                childRegistries.stream().filter(PrometheusMeterRegistry.class::isInstance).map(PrometheusMeterRegistry.class::cast).findAny().ifPresent(r -> ArmeriaConfigurationUtil.addPrometheusExposition(settings, server, r));
            } else if (meterRegistry instanceof PrometheusMeterRegistry) {
                ArmeriaConfigurationUtil.addPrometheusExposition(settings, server, (PrometheusMeterRegistry)meterRegistry);
            } else if (meterRegistry instanceof DropwizardMeterRegistry) {
                final MetricRegistry dropwizardRegistry = ((DropwizardMeterRegistry)meterRegistry).getDropwizardRegistry();
                final ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, true));
                server.service(settings.getMetricsPath(), (Service)new AbstractHttpService(){

                    protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
                        return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (byte[])objectMapper.writeValueAsBytes((Object)dropwizardRegistry));
                    }
                });
            }
        }
        if (settings.getSsl() != null) {
            ArmeriaConfigurationUtil.configureTls(server, settings.getSsl());
        }
    }

    public static void configurePorts(ServerBuilder server, List<ArmeriaSettings.Port> ports) {
        Objects.requireNonNull(server, METER_TYPE);
        Objects.requireNonNull(ports, "ports");
        ports.forEach(p -> {
            String ip = p.getIp();
            String iface = p.getIface();
            int port = p.getPort();
            List<SessionProtocol> protocols = p.getProtocols();
            if (ip == null) {
                if (iface == null) {
                    server.port(new ServerPort(port, protocols));
                    return;
                } else {
                    try {
                        Enumeration<InetAddress> e = NetworkInterface.getByName(iface).getInetAddresses();
                        while (e.hasMoreElements()) {
                            server.port(new ServerPort(new InetSocketAddress(e.nextElement(), port), protocols));
                        }
                        return;
                    }
                    catch (SocketException e) {
                        throw new IllegalStateException("Failed to find an iface: " + iface, e);
                    }
                }
            }
            if (iface != null) throw new IllegalStateException("A port cannot have both IP and iface: " + p);
            if (!NetUtil.isValidIpV4Address((String)ip) && !NetUtil.isValidIpV6Address((String)ip)) throw new IllegalStateException("invalid IP address: " + ip);
            byte[] bytes = NetUtil.createByteArrayFromIpAddressString((String)ip);
            try {
                server.port(new ServerPort(new InetSocketAddress(InetAddress.getByAddress(bytes), port), protocols));
                return;
            }
            catch (UnknownHostException e) {
                throw new Error(e);
            }
        });
    }

    public static void configureThriftServices(ServerBuilder server, List<ThriftServiceRegistrationBean> beans, @Nullable MeterIdPrefixFunctionFactory meterIdPrefixFunctionFactory, @Nullable String docsPath) {
        Objects.requireNonNull(server, METER_TYPE);
        Objects.requireNonNull(beans, "beans");
        ArrayList docServiceRequests = new ArrayList();
        HashMap docServiceHeaders = new HashMap();
        beans.forEach(bean -> {
            Service service = (Service)bean.getService();
            for (Function<Service<HttpRequest, HttpResponse>, Service<HttpRequest, HttpResponse>> decorator : bean.getDecorators()) {
                service = service.decorate(decorator);
            }
            service = ArmeriaConfigurationUtil.setupMetricCollectingService((Service<HttpRequest, HttpResponse>)service, bean, meterIdPrefixFunctionFactory);
            server.service(bean.getPath(), service);
            docServiceRequests.addAll(bean.getExampleRequests());
            ThriftServiceUtils.serviceNames((Service<HttpRequest, HttpResponse>)((Service)bean.getService())).forEach(serviceName -> docServiceHeaders.put(serviceName, bean.getExampleHeaders()));
        });
        if (!Strings.isNullOrEmpty((String)docsPath)) {
            DocServiceBuilder docServiceBuilder = new DocServiceBuilder();
            docServiceBuilder.exampleRequest(docServiceRequests);
            for (Map.Entry entry : docServiceHeaders.entrySet()) {
                docServiceBuilder.exampleHttpHeaders((String)entry.getKey(), (Iterable)entry.getValue());
            }
            server.serviceUnder(docsPath, (Service)docServiceBuilder.build());
        }
    }

    public static void configureHttpServices(ServerBuilder server, List<HttpServiceRegistrationBean> beans, @Nullable MeterIdPrefixFunctionFactory meterIdPrefixFunctionFactory) {
        Objects.requireNonNull(server, METER_TYPE);
        Objects.requireNonNull(beans, "beans");
        beans.forEach(bean -> {
            Service service = (Service)bean.getService();
            for (Function<Service<HttpRequest, HttpResponse>, Service<HttpRequest, HttpResponse>> decorator : bean.getDecorators()) {
                service = service.decorate(decorator);
            }
            service = ArmeriaConfigurationUtil.setupMetricCollectingService((Service<HttpRequest, HttpResponse>)service, bean, meterIdPrefixFunctionFactory);
            server.service(bean.getPathMapping(), service);
        });
    }

    public static void configureAnnotatedHttpServices(ServerBuilder server, List<AnnotatedServiceRegistrationBean> beans, @Nullable MeterIdPrefixFunctionFactory meterIdPrefixFunctionFactory) {
        Objects.requireNonNull(server, METER_TYPE);
        Objects.requireNonNull(beans, "beans");
        beans.forEach(bean -> {
            Function decorator = Function.identity();
            for (Function<Service<HttpRequest, HttpResponse>, Service<HttpRequest, HttpResponse>> d : bean.getDecorators()) {
                decorator = decorator.andThen(d);
            }
            if (meterIdPrefixFunctionFactory != null) {
                decorator = decorator.andThen(ArmeriaConfigurationUtil.metricCollectingServiceDecorator(bean, meterIdPrefixFunctionFactory));
            }
            ImmutableList exceptionHandlersAndConverters = ImmutableList.builder().addAll(bean.getExceptionHandlers()).addAll(bean.getRequestConverters()).addAll(bean.getResponseConverters()).build();
            server.annotatedService(bean.getPathPrefix(), bean.getService(), decorator, (Iterable)exceptionHandlersAndConverters);
        });
    }

    private static Service<HttpRequest, HttpResponse> setupMetricCollectingService(Service<HttpRequest, HttpResponse> service, AbstractServiceRegistrationBean<?, ?> bean, @Nullable MeterIdPrefixFunctionFactory meterIdPrefixFunctionFactory) {
        Objects.requireNonNull(service, "service");
        Objects.requireNonNull(bean, "bean");
        if (meterIdPrefixFunctionFactory == null) {
            return service;
        }
        return service.decorate(ArmeriaConfigurationUtil.metricCollectingServiceDecorator(bean, meterIdPrefixFunctionFactory));
    }

    private static Function<Service<HttpRequest, HttpResponse>, MetricCollectingService<HttpRequest, HttpResponse>> metricCollectingServiceDecorator(AbstractServiceRegistrationBean<?, ?> bean, MeterIdPrefixFunctionFactory meterIdPrefixFunctionFactory) {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(meterIdPrefixFunctionFactory, "meterIdPrefixFunctionFactory");
        return MetricCollectingService.newDecorator((MeterIdPrefixFunction)meterIdPrefixFunctionFactory.get(METER_TYPE, bean.getServiceName()));
    }

    private static void addPrometheusExposition(ArmeriaSettings armeriaSettings, ServerBuilder server, PrometheusMeterRegistry registry) {
        Objects.requireNonNull(armeriaSettings, "armeriaSettings");
        Objects.requireNonNull(server, METER_TYPE);
        Objects.requireNonNull(registry, "registry");
        String metricsPath = armeriaSettings.getMetricsPath();
        if (metricsPath == null) {
            return;
        }
        CollectorRegistry prometheusRegistry = registry.getPrometheusRegistry();
        server.service(metricsPath, (Service)new PrometheusExpositionService(prometheusRegistry));
    }

    public static void configureTls(ServerBuilder sb, Ssl ssl) {
        ArmeriaConfigurationUtil.configureTls(sb, ssl, null, null);
    }

    public static void configureTls(ServerBuilder sb, Ssl ssl, @Nullable Supplier<KeyStore> keyStoreSupplier, @Nullable Supplier<KeyStore> trustStoreSupplier) {
        if (!ssl.isEnabled()) {
            return;
        }
        try {
            ClientAuth clientAuth;
            List<String> ciphers;
            if (keyStoreSupplier == null && trustStoreSupplier == null && ssl.getKeyStore() == null && ssl.getTrustStore() == null) {
                logger.warn("Configuring TLS with a self-signed certificate because no key or trust store was specified");
                sb.tlsSelfSigned();
                return;
            }
            SslContextBuilder sslBuilder = SslContextBuilder.forServer((KeyManagerFactory)ArmeriaConfigurationUtil.getKeyManagerFactory(ssl, keyStoreSupplier)).trustManager(ArmeriaConfigurationUtil.getTrustManagerFactory(ssl, trustStoreSupplier));
            List<String> enabledProtocols = ssl.getEnabledProtocols();
            if (enabledProtocols != null) {
                sslBuilder.protocols(enabledProtocols.toArray(new String[enabledProtocols.size()]));
            }
            if ((ciphers = ssl.getCiphers()) != null) {
                sslBuilder.ciphers((Iterable)ImmutableList.copyOf(ciphers));
            }
            if ((clientAuth = ssl.getClientAuth()) != null) {
                sslBuilder.clientAuth(clientAuth);
            }
            sb.tls(sslBuilder.build());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to configure TLS: " + e, e);
        }
    }

    private static KeyManagerFactory getKeyManagerFactory(Ssl ssl, @Nullable Supplier<KeyStore> sslStoreProvider) throws Exception {
        KeyStore store = sslStoreProvider != null ? sslStoreProvider.get() : ArmeriaConfigurationUtil.loadKeyStore(ssl.getKeyStoreType(), ssl.getKeyStore(), ssl.getKeyStorePassword());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        String keyPassword = ssl.getKeyPassword();
        if (keyPassword == null) {
            keyPassword = ssl.getKeyStorePassword();
        }
        keyManagerFactory.init(store, keyPassword != null ? keyPassword.toCharArray() : null);
        return keyManagerFactory;
    }

    private static TrustManagerFactory getTrustManagerFactory(Ssl ssl, @Nullable Supplier<KeyStore> sslStoreProvider) throws Exception {
        KeyStore store = sslStoreProvider != null ? sslStoreProvider.get() : ArmeriaConfigurationUtil.loadKeyStore(ssl.getTrustStoreType(), ssl.getTrustStore(), ssl.getTrustStorePassword());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(store);
        return trustManagerFactory;
    }

    @Nullable
    private static KeyStore loadKeyStore(@Nullable String type, @Nullable String resource, @Nullable String password) throws IOException, GeneralSecurityException {
        if (resource == null) {
            return null;
        }
        KeyStore store = KeyStore.getInstance((String)MoreObjects.firstNonNull((Object)type, (Object)"JKS"));
        URL url = ResourceUtils.getURL((String)resource);
        store.load(url.openStream(), password != null ? password.toCharArray() : null);
        return store;
    }

    private ArmeriaConfigurationUtil() {
    }
}

