/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.spring.Ssl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="armeria")
@Validated
public class ArmeriaSettings {
    private List<Port> ports = new ArrayList<Port>();
    @Nullable
    private String healthCheckPath = "/internal/healthcheck";
    @Nullable
    private String docsPath = "/internal/docs/";
    @Nullable
    private String metricsPath = "/internal/metrics";
    private long gracefulShutdownQuietPeriodMillis = 5000L;
    private long gracefulShutdownTimeoutMillis = 40000L;
    private boolean enableMetrics = true;
    @Nullable
    private Ssl ssl;

    public List<Port> getPorts() {
        return this.ports;
    }

    public void setPorts(List<Port> ports) {
        this.ports = ports;
    }

    @Nullable
    public String getHealthCheckPath() {
        return this.healthCheckPath;
    }

    public void setHealthCheckPath(@Nullable String healthCheckPath) {
        this.healthCheckPath = healthCheckPath;
    }

    @Nullable
    public String getDocsPath() {
        return this.docsPath;
    }

    public void setDocsPath(@Nullable String docsPath) {
        this.docsPath = docsPath;
    }

    @Nullable
    public String getMetricsPath() {
        return this.metricsPath;
    }

    public void setMetricsPath(@Nullable String metricsPath) {
        this.metricsPath = metricsPath;
    }

    public long getGracefulShutdownQuietPeriodMillis() {
        return this.gracefulShutdownQuietPeriodMillis;
    }

    public void setGracefulShutdownQuietPeriodMillis(long gracefulShutdownQuietPeriodMillis) {
        this.gracefulShutdownQuietPeriodMillis = gracefulShutdownQuietPeriodMillis;
    }

    public long getGracefulShutdownTimeoutMillis() {
        return this.gracefulShutdownTimeoutMillis;
    }

    public void setGracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        this.gracefulShutdownTimeoutMillis = gracefulShutdownTimeoutMillis;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public void setEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
    }

    @Nullable
    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public static class Port {
        private String ip;
        private String iface;
        private int port;
        private List<SessionProtocol> protocols;

        @Nullable
        public String getIp() {
            return this.ip;
        }

        public Port setIp(String ip) {
            this.ip = ip;
            return this;
        }

        @Nullable
        public String getIface() {
            return this.iface;
        }

        public Port setIface(String iface) {
            this.iface = iface;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Port setPort(int port) {
            this.port = port;
            return this;
        }

        @Nullable
        public List<SessionProtocol> getProtocols() {
            return this.protocols;
        }

        public Port setProtocols(List<SessionProtocol> protocols) {
            this.protocols = ImmutableList.copyOf(protocols);
            return this;
        }

        public Port setProtocol(SessionProtocol protocol) {
            this.protocols = ImmutableList.of((Object)protocol);
            return this;
        }
    }
}

