/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.spring;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.spring.ArmeriaSettings;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import java.util.concurrent.TimeUnit;

final class DropwizardSupport {
    static boolean addExposition(ArmeriaSettings settings, ServerBuilder server, MeterRegistry meterRegistry) {
        String metricsPath = settings.getMetricsPath();
        assert (metricsPath != null);
        if (!(meterRegistry instanceof DropwizardMeterRegistry)) {
            return false;
        }
        MetricRegistry dropwizardRegistry = ((DropwizardMeterRegistry)meterRegistry).getDropwizardRegistry();
        ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, true));
        server.route().get(settings.getMetricsPath()).build((ctx, req) -> HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (byte[])objectMapper.writeValueAsBytes((Object)dropwizardRegistry)));
        return true;
    }

    private DropwizardSupport() {
    }
}

