/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.spring.ArmeriaConfigurationUtil;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.docs.DocServiceBuilder;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.spring.AnnotatedServiceRegistrationBean;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import com.linecorp.armeria.spring.ArmeriaSettings;
import com.linecorp.armeria.spring.DocServiceConfigurator;
import com.linecorp.armeria.spring.GrpcServiceRegistrationBean;
import com.linecorp.armeria.spring.HttpServiceRegistrationBean;
import com.linecorp.armeria.spring.MeterIdPrefixFunctionFactory;
import com.linecorp.armeria.spring.ThriftServiceRegistrationBean;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ArmeriaSettings.class})
@ConditionalOnMissingBean(value={Server.class})
public class ArmeriaAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaAutoConfiguration.class);
    private static final ArmeriaSettings.Port DEFAULT_PORT = new ArmeriaSettings.Port().setPort(8080).setProtocol(SessionProtocol.HTTP);

    @Bean
    @Nullable
    public Server armeriaServer(ArmeriaSettings armeriaSettings, Optional<MeterRegistry> meterRegistry, Optional<MeterIdPrefixFunctionFactory> meterIdPrefixFunctionFactory, Optional<List<HealthChecker>> healthCheckers, Optional<List<ArmeriaServerConfigurator>> armeriaServerConfigurators, Optional<List<Consumer<ServerBuilder>>> armeriaServerBuilderConsumers, Optional<List<ThriftServiceRegistrationBean>> thriftServiceRegistrationBeans, Optional<List<GrpcServiceRegistrationBean>> grpcServiceRegistrationBeans, Optional<List<HttpServiceRegistrationBean>> httpServiceRegistrationBeans, Optional<List<AnnotatedServiceRegistrationBean>> annotatedServiceRegistrationBeans, Optional<List<DocServiceConfigurator>> docServiceConfigurators) throws InterruptedException {
        if (!(armeriaServerConfigurators.isPresent() || armeriaServerBuilderConsumers.isPresent() || thriftServiceRegistrationBeans.isPresent() || grpcServiceRegistrationBeans.isPresent() || httpServiceRegistrationBeans.isPresent() || annotatedServiceRegistrationBeans.isPresent())) {
            return null;
        }
        MeterIdPrefixFunctionFactory meterIdPrefixFuncFactory = armeriaSettings.isEnableMetrics() ? meterIdPrefixFunctionFactory.orElse(MeterIdPrefixFunctionFactory.ofDefault()) : null;
        ServerBuilder serverBuilder = Server.builder();
        List<ArmeriaSettings.Port> ports = armeriaSettings.getPorts();
        if (ports.isEmpty()) {
            serverBuilder.port(new ServerPort(DEFAULT_PORT.getPort(), DEFAULT_PORT.getProtocols()));
        } else {
            ArmeriaConfigurationUtil.configurePorts(serverBuilder, ports);
        }
        DocServiceBuilder docServiceBuilder = DocService.builder();
        docServiceConfigurators.ifPresent(configurators -> configurators.forEach(configurator -> configurator.configure(docServiceBuilder)));
        String docsPath = armeriaSettings.getDocsPath();
        ArmeriaConfigurationUtil.configureThriftServices(serverBuilder, docServiceBuilder, thriftServiceRegistrationBeans.orElseGet(Collections::emptyList), meterIdPrefixFuncFactory, docsPath);
        ArmeriaConfigurationUtil.configureGrpcServices(serverBuilder, docServiceBuilder, grpcServiceRegistrationBeans.orElseGet(Collections::emptyList), meterIdPrefixFuncFactory, docsPath);
        ArmeriaConfigurationUtil.configureHttpServices(serverBuilder, httpServiceRegistrationBeans.orElseGet(Collections::emptyList), meterIdPrefixFuncFactory);
        ArmeriaConfigurationUtil.configureAnnotatedServices(serverBuilder, docServiceBuilder, annotatedServiceRegistrationBeans.orElseGet(Collections::emptyList), meterIdPrefixFuncFactory, docsPath);
        ArmeriaConfigurationUtil.configureServerWithArmeriaSettings(serverBuilder, armeriaSettings, meterRegistry.orElse((MeterRegistry)Metrics.globalRegistry), healthCheckers.orElseGet(Collections::emptyList));
        armeriaServerConfigurators.ifPresent(configurators -> configurators.forEach(configurator -> configurator.configure(serverBuilder)));
        armeriaServerBuilderConsumers.ifPresent(consumers -> consumers.forEach(consumer -> consumer.accept(serverBuilder)));
        if (!Strings.isNullOrEmpty((String)docsPath)) {
            serverBuilder.serviceUnder(docsPath, (HttpService)docServiceBuilder.build());
        }
        Server server = serverBuilder.build();
        ((CompletableFuture)server.start().handle((result, t) -> {
            if (t != null) {
                throw new IllegalStateException("Armeria server failed to start", (Throwable)t);
            }
            return result;
        })).join();
        logger.info("Armeria server started at ports: {}", (Object)server.activePorts());
        return server;
    }
}

