/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.spring;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.spring.ArmeriaSettings;
import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;

public final class ArmeriaConfigurationNetUtil {
    public static void configurePorts(ServerBuilder server, List<ArmeriaSettings.Port> ports) {
        Objects.requireNonNull(server, "server");
        Objects.requireNonNull(ports, "ports");
        ports.forEach(p -> {
            String ip = p.getIp();
            String iface = p.getIface();
            int port = p.getPort();
            List protocols = (List)MoreObjects.firstNonNull(p.getProtocols(), (Object)ImmutableList.of((Object)SessionProtocol.HTTP));
            if (ip == null) {
                if (iface == null) {
                    server.port(new ServerPort(port, (Iterable)protocols));
                    return;
                } else {
                    try {
                        Enumeration<InetAddress> e = NetworkInterface.getByName(iface).getInetAddresses();
                        while (e.hasMoreElements()) {
                            server.port(new ServerPort(new InetSocketAddress(e.nextElement(), port), (Iterable)protocols));
                        }
                        return;
                    }
                    catch (SocketException e) {
                        throw new IllegalStateException("Failed to find an iface: " + iface, e);
                    }
                }
            }
            if (iface != null) throw new IllegalStateException("A port cannot have both IP and iface: " + p);
            if (!NetUtil.isValidIpV4Address((String)ip) && !NetUtil.isValidIpV6Address((String)ip)) throw new IllegalStateException("invalid IP address: " + ip);
            byte[] bytes = NetUtil.createByteArrayFromIpAddressString((String)ip);
            try {
                server.port(new ServerPort(new InetSocketAddress(InetAddress.getByAddress(bytes), port), (Iterable)protocols));
                return;
            }
            catch (UnknownHostException e) {
                throw new Error(e);
            }
        });
    }

    private ArmeriaConfigurationNetUtil() {
    }
}

