/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.spring;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.spring.ArmeriaSettings;
import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.springframework.util.SocketUtils;

public final class ArmeriaConfigurationNetUtil {
    public static void configurePorts(ServerBuilder server, List<ArmeriaSettings.Port> ports) {
        Objects.requireNonNull(server, "server");
        Objects.requireNonNull(ports, "ports");
        ports.forEach(p -> {
            String iface = p.getIface();
            int port = p.getPort();
            List protocols = (List)MoreObjects.firstNonNull(p.getProtocols(), (Object)ImmutableList.of((Object)SessionProtocol.HTTP));
            InetSocketAddress socketAddress = ArmeriaConfigurationNetUtil.createSocketAddress(p);
            if (socketAddress == null) {
                if (iface == null) {
                    server.port(new ServerPort(port, (Iterable)protocols));
                } else {
                    try {
                        Enumeration<InetAddress> e = NetworkInterface.getByName(iface).getInetAddresses();
                        while (e.hasMoreElements()) {
                            server.port(new ServerPort(new InetSocketAddress(e.nextElement(), port), (Iterable)protocols));
                        }
                    }
                    catch (SocketException e) {
                        throw new IllegalStateException("Failed to find an iface: " + iface, e);
                    }
                }
            } else if (iface == null) {
                server.port(new ServerPort(socketAddress, (Iterable)protocols));
            } else {
                throw new IllegalStateException("A port cannot have both IP and iface: " + p);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static InetSocketAddress createSocketAddress(ArmeriaSettings.Port p) {
        InetAddress address = p.getAddress();
        String ip = p.getIp();
        int port = p.getPort();
        if (ip != null && address != null) {
            throw new IllegalStateException("A port cannot have both IP and address: " + p);
        }
        if (ip != null) {
            if (!NetUtil.isValidIpV4Address((String)ip)) {
                if (!NetUtil.isValidIpV6Address((String)ip)) throw new IllegalStateException("invalid IP address: " + ip);
            }
            byte[] bytes = NetUtil.createByteArrayFromIpAddressString((String)ip);
            try {
                return new InetSocketAddress(InetAddress.getByAddress(bytes), port);
            }
            catch (UnknownHostException e) {
                throw new Error(e);
            }
        }
        if (address == null) return null;
        return new InetSocketAddress(address, port);
    }

    @Nullable
    public static ArmeriaSettings.Port maybeNewPort(@Nullable Integer port, SessionProtocol protocol) {
        if (port == null || port < 0) {
            return null;
        }
        if (port == 0) {
            port = SocketUtils.findAvailableTcpPort();
        }
        return new ArmeriaSettings.Port().setPort(port).setProtocol(protocol);
    }

    private ArmeriaConfigurationNetUtil() {
    }
}

