/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.spring.ArmeriaConfigurationNetUtil;
import com.linecorp.armeria.internal.spring.ArmeriaConfigurationUtil;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.docs.DocServiceBuilder;
import com.linecorp.armeria.server.healthcheck.HealthCheckService;
import com.linecorp.armeria.server.healthcheck.HealthCheckServiceBuilder;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.spring.ArmeriaSettings;
import com.linecorp.armeria.spring.DocServiceConfigurator;
import com.linecorp.armeria.spring.DropwizardSupport;
import com.linecorp.armeria.spring.HealthCheckServiceConfigurator;
import com.linecorp.armeria.spring.PrometheusSupport;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.SocketUtils;

public final class InternalServices {
    private static final Logger logger = LoggerFactory.getLogger(InternalServices.class);
    @Nullable
    private final DocService docService;
    @Nullable
    private final HttpService metricsExpositionService;
    @Nullable
    private final HealthCheckService healthCheckService;
    @Nullable
    private final ArmeriaSettings.Port internalServicePort;
    @Nullable
    private final ArmeriaSettings.Port managementServerPort;

    private static boolean hasAllClasses(String ... classNames) {
        for (String className : classNames) {
            try {
                Class.forName(className, false, ArmeriaConfigurationUtil.class.getClassLoader());
            }
            catch (Throwable t) {
                return false;
            }
        }
        return true;
    }

    public static InternalServices of(ArmeriaSettings settings, MeterRegistry meterRegistry, List<HealthChecker> healthCheckers, List<HealthCheckServiceConfigurator> healthCheckServiceConfigurators, List<DocServiceConfigurator> docServiceConfigurators, @Nullable Integer managementServerPort) {
        ArmeriaSettings.InternalServiceProperties internalPort;
        DocService docService = null;
        if (!Strings.isNullOrEmpty((String)settings.getDocsPath())) {
            DocServiceBuilder docServiceBuilder = DocService.builder();
            docServiceConfigurators.forEach(configurator -> configurator.configure(docServiceBuilder));
            docService = docServiceBuilder.build();
        }
        HealthCheckService healthCheckService = null;
        if (!Strings.isNullOrEmpty((String)settings.getHealthCheckPath())) {
            HealthCheckServiceBuilder builder = HealthCheckService.builder().checkers(healthCheckers);
            healthCheckServiceConfigurators.forEach(configurator -> configurator.configure(builder));
            healthCheckService = builder.build();
        } else if (!healthCheckServiceConfigurators.isEmpty()) {
            logger.warn("{}s exist but they are disabled by the empty 'health-check-path' property. configurators: {}", (Object)HealthCheckServiceConfigurator.class.getSimpleName(), healthCheckServiceConfigurators);
        }
        Object expositionService = null;
        if (settings.isEnableMetrics() && !Strings.isNullOrEmpty((String)settings.getMetricsPath())) {
            boolean hasDropwizard;
            String prometheusMeterRegistryClassName = "io.micrometer.prometheus.PrometheusMeterRegistry";
            boolean hasPrometheus = InternalServices.hasAllClasses("io.micrometer.prometheus.PrometheusMeterRegistry", "io.prometheus.client.CollectorRegistry");
            if (hasPrometheus) {
                expositionService = PrometheusSupport.newExpositionService(meterRegistry);
            }
            String dropwizardMeterRegistryClassName = "io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry";
            if (expositionService == null && (hasDropwizard = InternalServices.hasAllClasses("io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry", "com.codahale.metrics.MetricRegistry", "com.codahale.metrics.json.MetricsModule"))) {
                expositionService = DropwizardSupport.newExpositionService(meterRegistry);
            }
            if (expositionService == null) {
                logger.debug("Failed to expose metrics to '{}' with {} (expected: either {} or {})", new Object[]{settings.getMetricsPath(), meterRegistry, "io.micrometer.prometheus.PrometheusMeterRegistry", "io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry"});
            }
        }
        if ((internalPort = settings.getInternalServices()) != null && internalPort.getPort() == 0) {
            internalPort.setPort(SocketUtils.findAvailableTcpPort());
        }
        return new InternalServices(docService, (HttpService)expositionService, healthCheckService, internalPort, ArmeriaConfigurationNetUtil.maybeNewPort(managementServerPort, SessionProtocol.HTTP));
    }

    private InternalServices(@Nullable DocService docService, @Nullable HttpService metricsExpositionService, @Nullable HealthCheckService healthCheckService, @Nullable ArmeriaSettings.Port internalServicePort, @Nullable ArmeriaSettings.Port managementServerPort) {
        this.healthCheckService = healthCheckService;
        this.metricsExpositionService = metricsExpositionService;
        this.docService = docService;
        this.internalServicePort = internalServicePort;
        this.managementServerPort = managementServerPort;
    }

    @Nullable
    public DocService docService() {
        return this.docService;
    }

    @Nullable
    public HttpService metricsExpositionService() {
        return this.metricsExpositionService;
    }

    @Nullable
    public HealthCheckService healthCheckService() {
        return this.healthCheckService;
    }

    @Nullable
    public ArmeriaSettings.Port internalServicePort() {
        return this.internalServicePort;
    }

    @Nullable
    public ArmeriaSettings.Port managementServerPort() {
        return this.managementServerPort;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("docService", (Object)this.docService).add("metricsExpositionService", (Object)this.metricsExpositionService).add("healthCheckService", (Object)this.healthCheckService).add("internalServicePort", (Object)this.internalServicePort).add("managementServerPort", (Object)this.managementServerPort).toString();
    }
}

