/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.spring;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.springframework.util.ReflectionUtils;

final class ThriftServiceUtils {
    @Nullable
    private static final Class<?> thriftServiceClass;
    @Nullable
    private static final Method entriesMethod;
    @Nullable
    private static final Method interfacesMethod;

    private ThriftServiceUtils() {
    }

    @Nullable
    private static Class<?> findClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static Set<String> serviceNames(HttpService service) {
        if (thriftServiceClass == null || entriesMethod == null || interfacesMethod == null) {
            return ImmutableSet.of();
        }
        Object thriftService = service.as(thriftServiceClass);
        if (thriftService == null) {
            return ImmutableSet.of();
        }
        Map entries = (Map)ReflectionUtils.invokeMethod((Method)entriesMethod, (Object)thriftService);
        assert (entries != null);
        return ThriftServiceUtils.toServiceName(entries.values());
    }

    private static Set<String> toServiceName(Collection<?> entries) {
        return (Set)entries.stream().flatMap(entry -> {
            Set ifaces = (Set)ReflectionUtils.invokeMethod((Method)interfacesMethod, (Object)entry);
            assert (ifaces != null);
            return ifaces.stream();
        }).map(iface -> iface.getEnclosingClass().getName()).collect(ImmutableSet.toImmutableSet());
    }

    static {
        String serverPackageName = Server.class.getPackage().getName();
        thriftServiceClass = ThriftServiceUtils.findClass(serverPackageName + ".thrift.THttpService");
        entriesMethod = thriftServiceClass != null ? ReflectionUtils.findMethod(thriftServiceClass, (String)"entries") : null;
        Class<?> thriftServiceEntryClass = ThriftServiceUtils.findClass(serverPackageName + ".thrift.ThriftServiceEntry");
        interfacesMethod = thriftServiceEntryClass != null ? ReflectionUtils.findMethod(thriftServiceEntryClass, (String)"interfaces") : null;
    }
}

