/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.spring.web.reactive.DataBufferFactoryWrapper;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ArmeriaClientHttpRequest
extends AbstractClientHttpRequest {
    private final WebClient client;
    private final RequestHeadersBuilder headers;
    private final DataBufferFactoryWrapper<?> factoryWrapper;
    private final HttpMethod httpMethod;
    private final URI uri;
    private final CompletableFuture<HttpResponse> future = new CompletableFuture();
    @Nullable
    private HttpRequest request;

    ArmeriaClientHttpRequest(WebClient client, HttpMethod httpMethod, String pathAndQuery, URI uri, DataBufferFactoryWrapper<?> factoryWrapper) {
        this.client = Objects.requireNonNull(client, "client");
        this.httpMethod = Objects.requireNonNull(httpMethod, "httpMethod");
        this.uri = Objects.requireNonNull(uri, "uri");
        this.factoryWrapper = Objects.requireNonNull(factoryWrapper, "factoryWrapper");
        this.headers = RequestHeaders.builder().add((CharSequence)HttpHeaderNames.METHOD, httpMethod.name()).add((CharSequence)HttpHeaderNames.PATH, Objects.requireNonNull(pathAndQuery, "pathAndQuery"));
    }

    protected void applyHeaders() {
        this.getHeaders().forEach((name, values) -> this.headers.set((CharSequence)HttpHeaderNames.of((CharSequence)name), (Iterable)values));
        ArmeriaClientHttpRequest.setDefaultRequestHeaders(this.headers);
    }

    protected void applyCookies() {
        List cookieValues = (List)this.getCookies().values().stream().flatMap(Collection::stream).map(HttpCookie::toString).collect(ImmutableList.toImmutableList());
        if (!cookieValues.isEmpty()) {
            this.headers.add((CharSequence)HttpHeaderNames.COOKIE, (Iterable)cookieValues);
        }
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public URI getURI() {
        return this.uri;
    }

    @Nullable
    public <T> T getNativeRequest() {
        if (this.request == null) {
            return null;
        }
        return (T)this.request;
    }

    public DataBufferFactory bufferFactory() {
        return this.factoryWrapper.delegate();
    }

    public CompletableFuture<HttpResponse> future() {
        return this.future;
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return this.write((Flux<? extends DataBuffer>)Flux.from(body));
    }

    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.write((Flux<? extends DataBuffer>)Flux.from(body).concatMap(Flux::from, 1));
    }

    private Mono<Void> write(Flux<? extends DataBuffer> body) {
        return this.doCommit(this.execute(() -> HttpRequest.of((RequestHeaders)this.headers.build(), (Publisher)body.map(this.factoryWrapper::toHttpData))));
    }

    public Mono<Void> setComplete() {
        return this.isCommitted() ? Mono.empty() : this.doCommit(this.execute(() -> HttpRequest.of((RequestHeaders)this.headers.build())));
    }

    private Supplier<Mono<Void>> execute(Supplier<HttpRequest> supplier) {
        return () -> Mono.defer(() -> this.lambda$execute$3((Supplier)supplier));
    }

    @Nullable
    @VisibleForTesting
    HttpRequest request() {
        return this.request;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("client", (Object)this.client).add("headers", (Object)this.headers).add("factoryWrapper", this.factoryWrapper).add("httpMethod", (Object)this.httpMethod).add("uri", (Object)this.uri).add("request", (Object)this.request).toString();
    }

    private static void setDefaultRequestHeaders(RequestHeadersBuilder headers) {
        if (headers.accept().isEmpty()) {
            headers.accept(new MediaType[]{MediaType.ANY_TYPE});
        }
    }

    private /* synthetic */ Mono lambda$execute$3(Supplier supplier) {
        assert (this.request == null) : this.request;
        this.request = (HttpRequest)supplier.get();
        this.future.complete(this.client.execute(this.request));
        return Mono.empty();
    }
}

