/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.internal.common.DefaultSplitHttpResponse;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;

final class ArmeriaHttpResponseBodyStream
extends DefaultSplitHttpResponse {
    private static final AtomicIntegerFieldUpdater<ArmeriaHttpResponseBodyStream> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(ArmeriaHttpResponseBodyStream.class, "subscribed");
    private static final AtomicReferenceFieldUpdater<ArmeriaHttpResponseBodyStream, Publisher> publisherForLateSubscribersUpdater = AtomicReferenceFieldUpdater.newUpdater(ArmeriaHttpResponseBodyStream.class, Publisher.class, "publisherForLateSubscribers");
    private volatile int subscribed;
    @Nullable
    private volatile Publisher<HttpData> publisherForLateSubscribers;

    ArmeriaHttpResponseBodyStream(HttpResponse httpResponse, EventExecutor executor) {
        super(httpResponse, executor);
    }

    public void subscribe(Subscriber<? super HttpData> s) {
        if (subscribedUpdater.compareAndSet(this, 0, 1)) {
            super.subscribe(s);
        } else {
            Publisher<HttpData> publisherForLateSubscribers = this.publisherForLateSubscribers;
            if (publisherForLateSubscribers != null) {
                publisherForLateSubscribers.subscribe(s);
                return;
            }
            Mono newPublisher = Mono.fromFuture((CompletableFuture)this.whenComplete()).onErrorResume(CancelledSubscriptionException.class::isInstance, cause -> Mono.empty());
            if (publisherForLateSubscribersUpdater.compareAndSet(this, null, (Publisher)newPublisher)) {
                newPublisher.subscribe(s);
            } else {
                this.publisherForLateSubscribers.subscribe(s);
            }
        }
    }
}

