/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import com.linecorp.armeria.internal.spring.ArmeriaConfigurationUtil;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import com.linecorp.armeria.spring.ArmeriaSettings;
import com.linecorp.armeria.spring.DocServiceConfigurator;
import com.linecorp.armeria.spring.HealthCheckServiceConfigurator;
import com.linecorp.armeria.spring.InternalServices;
import com.linecorp.armeria.spring.MetricCollectingServiceConfigurator;
import com.linecorp.armeria.spring.Ssl;
import com.linecorp.armeria.spring.web.reactive.ArmeriaHttpHandlerAdapter;
import com.linecorp.armeria.spring.web.reactive.ArmeriaWebServer;
import com.linecorp.armeria.spring.web.reactive.DataBufferFactoryWrapper;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.netty.handler.ssl.ClientAuth;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.Compression;
import org.springframework.boot.web.server.Http2;
import org.springframework.boot.web.server.SslStoreProvider;
import org.springframework.boot.web.server.WebServer;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.http.server.reactive.HttpHandler;
import reactor.core.Disposable;

public class ArmeriaReactiveWebServerFactory
extends AbstractReactiveWebServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaReactiveWebServerFactory.class);
    private final ConfigurableListableBeanFactory beanFactory;
    private final Environment environment;

    public ArmeriaReactiveWebServerFactory(ConfigurableListableBeanFactory beanFactory, Environment environment) {
        this.beanFactory = Objects.requireNonNull(beanFactory, "beanFactory");
        this.environment = environment;
    }

    private static Ssl toArmeriaSslConfiguration(org.springframework.boot.web.server.Ssl ssl) {
        if (!ssl.isEnabled()) {
            return new Ssl();
        }
        ClientAuth clientAuth = null;
        if (ssl.getClientAuth() != null) {
            switch (ssl.getClientAuth()) {
                case NEED: {
                    clientAuth = ClientAuth.REQUIRE;
                    break;
                }
                case WANT: {
                    clientAuth = ClientAuth.OPTIONAL;
                }
            }
        }
        return new Ssl().setEnabled(ssl.isEnabled()).setClientAuth(clientAuth).setCiphers((List<String>)(ssl.getCiphers() != null ? ImmutableList.copyOf((Object[])ssl.getCiphers()) : null)).setEnabledProtocols((List<String>)(ssl.getEnabledProtocols() != null ? ImmutableList.copyOf((Object[])ssl.getEnabledProtocols()) : null)).setKeyAlias(ssl.getKeyAlias()).setKeyPassword(ssl.getKeyPassword()).setKeyStore(ssl.getKeyStore()).setKeyStorePassword(ssl.getKeyStorePassword()).setKeyStoreType(ssl.getKeyStoreType()).setKeyStoreProvider(ssl.getKeyStoreProvider()).setTrustStore(ssl.getTrustStore()).setTrustStorePassword(ssl.getTrustStorePassword()).setTrustStoreType(ssl.getTrustStoreType()).setTrustStoreProvider(ssl.getTrustStoreProvider());
    }

    public WebServer getWebServer(HttpHandler httpHandler) {
        SessionProtocol primarySessionProtocol;
        int primaryLocalPort;
        InetAddress primaryAddress;
        SessionProtocol springSessionProtocol;
        Compression compression;
        ArmeriaWebServer armeriaWebServerBean = this.findBean(ArmeriaWebServer.class);
        if (armeriaWebServerBean != null) {
            return armeriaWebServerBean;
        }
        Http2 http2 = this.getHttp2();
        if (http2 != null && !http2.isEnabled()) {
            logger.warn("Cannot disable HTTP/2 protocol for Armeria server. It will be enabled automatically.");
        }
        ServerBuilder sb = Server.builder();
        sb.disableServerHeader();
        sb.disableDateHeader();
        ArmeriaSettings armeriaSettings = this.findBean(ArmeriaSettings.class);
        if (!ArmeriaReactiveWebServerFactory.isArmeriaCompressionEnabled(armeriaSettings) && (compression = this.getCompression()) != null && compression.getEnabled()) {
            long minResponseSize = compression.getMinResponseSize().toBytes();
            sb.decorator(ArmeriaConfigurationUtil.contentEncodingDecorator(compression.getMimeTypes(), compression.getExcludedUserAgents(), Ints.saturatedCast((long)minResponseSize)));
        }
        if (armeriaSettings != null) {
            MeterRegistry meterRegistry = (MeterRegistry)MoreObjects.firstNonNull((Object)this.findBean(MeterRegistry.class), (Object)Metrics.globalRegistry);
            ArmeriaConfigurationUtil.configureServerWithArmeriaSettings(sb, armeriaSettings, this.newInternalServices(armeriaSettings, meterRegistry), this.findBeans(ArmeriaServerConfigurator.class), this.findBeans(Consumer.class, ServerBuilder.class), meterRegistry, this.meterIdPrefixFunctionOrDefault(), this.findBeans(MetricCollectingServiceConfigurator.class), (BeanFactory)this.beanFactory);
        }
        boolean armeriaSslEnabled = ArmeriaReactiveWebServerFactory.isArmeriaSslEnabled(armeriaSettings);
        org.springframework.boot.web.server.Ssl springSsl = this.getSsl();
        if (springSsl != null && springSsl.isEnabled()) {
            if (armeriaSslEnabled) {
                logger.warn("Both Armeria and Spring TLS configuration exist. Armeria TLS configuration is used.");
            } else {
                this.configureTls(sb, ArmeriaReactiveWebServerFactory.toArmeriaSslConfiguration(springSsl));
            }
            springSessionProtocol = SessionProtocol.HTTPS;
        } else {
            springSessionProtocol = SessionProtocol.HTTP;
        }
        int springPort = ArmeriaReactiveWebServerFactory.ensureValidPort(this.getPort());
        List<ServerPort> armeriaPorts = ArmeriaReactiveWebServerFactory.armeriaPorts(sb);
        if (springPort > 0 || armeriaPorts.isEmpty()) {
            primaryAddress = this.getAddress();
            primaryLocalPort = springPort;
            primarySessionProtocol = springPort == 0 ? (armeriaSslEnabled ? SessionProtocol.HTTPS : springSessionProtocol) : springSessionProtocol;
            if (primaryAddress != null) {
                sb.port(new InetSocketAddress(primaryAddress, primaryLocalPort), new SessionProtocol[]{primarySessionProtocol});
            } else {
                sb.port(primaryLocalPort, new SessionProtocol[]{primarySessionProtocol});
            }
        } else {
            ServerPort armeriaFirstPort = armeriaPorts.get(0);
            InetSocketAddress inetSocketAddress = armeriaFirstPort.localAddress();
            primaryAddress = null;
            primaryLocalPort = inetSocketAddress.getPort();
            primarySessionProtocol = armeriaFirstPort.hasTls() ? SessionProtocol.HTTPS : SessionProtocol.HTTP;
        }
        DataBufferFactoryWrapper factoryWrapper = (DataBufferFactoryWrapper)MoreObjects.firstNonNull((Object)this.findBean(DataBufferFactoryWrapper.class), DataBufferFactoryWrapper.DEFAULT);
        Server server = ArmeriaReactiveWebServerFactory.configureService(sb, httpHandler, factoryWrapper, this.getServerHeader()).build();
        ArmeriaWebServer armeriaWebServer = new ArmeriaWebServer(server, primarySessionProtocol, primaryAddress, primaryLocalPort, this.beanFactory);
        if (!this.isManagementPortEqualsToServerPort()) {
            this.beanFactory.registerSingleton("armeriaWebServer", (Object)armeriaWebServer);
        }
        return armeriaWebServer;
    }

    private InternalServices newInternalServices(ArmeriaSettings settings, MeterRegistry meterRegistry) {
        String property;
        ConfigurableEnvironment environment = this.findBean(ConfigurableEnvironment.class);
        Integer port = null;
        if (environment != null && (property = environment.getProperty("management.server.port")) != null) {
            port = Integer.parseInt(property);
        }
        return InternalServices.of(settings, meterRegistry, this.findBeans(HealthChecker.class), this.findBeans(HealthCheckServiceConfigurator.class), this.findBeans(DocServiceConfigurator.class), port);
    }

    private static List<ServerPort> armeriaPorts(ServerBuilder sb) {
        try {
            Field ports = ServerBuilder.class.getDeclaredField("ports");
            ports.setAccessible(true);
            List armeriaPorts = (List)ports.get(sb);
            return armeriaPorts;
        }
        catch (NoSuchFieldException ignored) {
            throw new Error();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to get ports in " + ServerBuilder.class.getSimpleName() + " via reflection.", e);
        }
    }

    private static boolean isArmeriaSslEnabled(@Nullable ArmeriaSettings armeriaSettings) {
        Ssl ssl;
        if (armeriaSettings != null && (ssl = armeriaSettings.getSsl()) != null) {
            return ssl.isEnabled();
        }
        return false;
    }

    private static boolean isArmeriaCompressionEnabled(@Nullable ArmeriaSettings armeriaSettings) {
        ArmeriaSettings.Compression compression;
        if (armeriaSettings != null && (compression = armeriaSettings.getCompression()) != null) {
            return compression.isEnabled();
        }
        return false;
    }

    private void configureTls(ServerBuilder sb, Ssl ssl) {
        Supplier<KeyStore> trustStoreSupplier;
        Supplier<KeyStore> keyStoreSupplier;
        SslStoreProvider provider = this.getSslStoreProvider();
        if (provider != null) {
            keyStoreSupplier = () -> {
                try {
                    return provider.getKeyStore();
                }
                catch (Exception e) {
                    return (KeyStore)Exceptions.throwUnsafely((Throwable)e);
                }
            };
            trustStoreSupplier = () -> {
                try {
                    return provider.getTrustStore();
                }
                catch (Exception e) {
                    return (KeyStore)Exceptions.throwUnsafely((Throwable)e);
                }
            };
        } else {
            keyStoreSupplier = null;
            trustStoreSupplier = null;
        }
        ArmeriaConfigurationUtil.configureTls(sb, ssl, keyStoreSupplier, trustStoreSupplier);
    }

    private MeterIdPrefixFunction meterIdPrefixFunctionOrDefault() {
        MeterIdPrefixFunction f = this.findBean(MeterIdPrefixFunction.class);
        return f != null ? f : MeterIdPrefixFunction.ofDefault((String)"armeria.server");
    }

    @VisibleForTesting
    boolean isManagementPortEqualsToServerPort() {
        Integer managementPort = (Integer)this.environment.getProperty("management.server.port", Integer.class);
        if (managementPort == null) {
            return true;
        }
        Integer ensuredManagementPort = ArmeriaReactiveWebServerFactory.ensureValidPort(managementPort);
        Integer serverPort = (Integer)this.environment.getProperty("server.port", Integer.class);
        return serverPort == null && ensuredManagementPort.equals(8080) || ensuredManagementPort != 0 && ensuredManagementPort.equals(serverPort);
    }

    private static ServerBuilder configureService(ServerBuilder sb, HttpHandler httpHandler, DataBufferFactoryWrapper<?> factoryWrapper, @Nullable String serverHeader) {
        ArmeriaHttpHandlerAdapter handler = new ArmeriaHttpHandlerAdapter(httpHandler, factoryWrapper);
        return sb.route().addRoute(Route.ofCatchAll()).defaultServiceName("SpringWebFlux").build((ctx, req) -> {
            CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
            HttpResponse response = HttpResponse.from(future);
            Disposable disposable = handler.handle(ctx, req, future, serverHeader).subscribe();
            response.whenComplete().handle((unused, cause) -> {
                if (cause != null) {
                    if (ctx.method() != HttpMethod.HEAD) {
                        logger.debug("{} Response stream has been cancelled.", (Object)ctx, cause);
                    }
                    disposable.dispose();
                }
                return null;
            });
            return response;
        });
    }

    @Nullable
    private <T> T findBean(Class<T> clazz) {
        try {
            return (T)this.beanFactory.getBean(clazz);
        }
        catch (NoUniqueBeanDefinitionException e) {
            throw new IllegalStateException("Too many " + clazz.getSimpleName() + " beans: (expected: 1)", e);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    private <T> List<T> findBeans(Class<T> clazz) {
        String[] names = this.beanFactory.getBeanNamesForType(clazz);
        if (names.length == 0) {
            return ImmutableList.of();
        }
        return (List)Arrays.stream(names).map(name -> this.beanFactory.getBean(name, clazz)).collect(ImmutableList.toImmutableList());
    }

    private <T> List<T> findBeans(Class<?> containerType, Class<?> genericType) {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(containerType, (Class[])new Class[]{genericType});
        String[] names = this.beanFactory.getBeanNamesForType(resolvableType);
        if (names.length == 0) {
            return ImmutableList.of();
        }
        List beans = (List)Arrays.stream(names).map(arg_0 -> ((ConfigurableListableBeanFactory)this.beanFactory).getBean(arg_0)).collect(ImmutableList.toImmutableList());
        return beans;
    }

    private static int ensureValidPort(int port) {
        Preconditions.checkArgument((port >= 0 && port <= 65535 ? 1 : 0) != 0, (String)"port: %s (expected: 0[arbitrary port] or 1-65535)", (int)port);
        return port;
    }
}

