/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.CookieBuilder;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.spring.web.reactive.DataBufferFactoryWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ArmeriaServerHttpResponse
extends AbstractServerHttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaServerHttpResponse.class);
    private final ServiceRequestContext ctx;
    private final CompletableFuture<HttpResponse> future;
    private final DataBufferFactoryWrapper<?> factoryWrapper;
    private final ResponseHeadersBuilder armeriaHeaders = ResponseHeaders.builder();

    ArmeriaServerHttpResponse(ServiceRequestContext ctx, CompletableFuture<HttpResponse> future, DataBufferFactoryWrapper<?> factoryWrapper, @Nullable String serverHeader) {
        super(Objects.requireNonNull(factoryWrapper, "factoryWrapper").delegate());
        this.ctx = Objects.requireNonNull(ctx, "ctx");
        this.future = Objects.requireNonNull(future, "future");
        this.factoryWrapper = factoryWrapper;
        if (!Strings.isNullOrEmpty((String)serverHeader)) {
            this.armeriaHeaders.set((CharSequence)HttpHeaderNames.SERVER, serverHeader);
        }
    }

    public <T> T getNativeResponse() {
        return (T)this.future;
    }

    private Mono<Void> write(Flux<? extends DataBuffer> publisher) {
        return Mono.deferContextual(contextView -> {
            HttpResponse response = HttpResponse.of((ResponseHeaders)this.armeriaHeaders.build(), (Publisher)publisher.map(this.factoryWrapper::toHttpData).contextWrite(contextView).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release));
            this.future.complete(response);
            return Mono.fromFuture((CompletableFuture)response.whenComplete()).onErrorResume(cause -> cause instanceof CancelledSubscriptionException || cause instanceof AbortedStreamException, cause -> Mono.empty());
        });
    }

    protected Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> body) {
        return this.write((Flux<? extends DataBuffer>)Flux.from(body));
    }

    protected Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.write((Flux<? extends DataBuffer>)Flux.from(body).concatMap(Flux::from, 1));
    }

    protected void applyStatusCode() {
        HttpStatus httpStatus = this.getStatusCode();
        if (httpStatus != null) {
            this.armeriaHeaders.status(httpStatus.value());
        } else {
            this.armeriaHeaders.status(com.linecorp.armeria.common.HttpStatus.OK);
        }
    }

    protected void applyHeaders() {
        this.getHeaders().forEach((name, values) -> this.armeriaHeaders.add((CharSequence)HttpHeaderNames.of((CharSequence)name), (Iterable)values));
    }

    protected void applyCookies() {
        List cookieValues = (List)this.getCookies().values().stream().flatMap(Collection::stream).map(ArmeriaServerHttpResponse::toSetCookie).collect(ImmutableList.toImmutableList());
        if (!cookieValues.isEmpty()) {
            this.armeriaHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Iterable)cookieValues);
        }
    }

    private static String toSetCookie(ResponseCookie resCookie) {
        CookieBuilder builder = Cookie.builder((String)resCookie.getName(), (String)resCookie.getValue());
        if (!resCookie.getMaxAge().isNegative()) {
            builder.maxAge(resCookie.getMaxAge().getSeconds());
        }
        if (resCookie.getDomain() != null) {
            builder.domain(resCookie.getDomain());
        }
        if (resCookie.getPath() != null) {
            builder.path(resCookie.getPath());
        }
        builder.secure(resCookie.isSecure());
        builder.httpOnly(resCookie.isHttpOnly());
        if (resCookie.getSameSite() != null) {
            builder.sameSite(resCookie.getSameSite());
        }
        Cookie cookie = builder.build();
        return cookie.toSetCookieHeader(false);
    }

    public Mono<Void> setComplete() {
        return this.setComplete(null);
    }

    public Mono<Void> setComplete(@Nullable Throwable cause) {
        return !this.isCommitted() ? this.doCommit(null).then(Mono.defer(() -> this.cleanup(cause))) : Mono.defer(() -> this.cleanup(cause));
    }

    private Mono<Void> cleanup(@Nullable Throwable cause) {
        if (this.future.isDone()) {
            return Mono.empty();
        }
        if (cause != null) {
            this.future.completeExceptionally(cause);
            logger.debug("{} Response future has been completed with a cause", (Object)this.ctx, (Object)cause);
            return Mono.empty();
        }
        HttpResponse response = HttpResponse.of((ResponseHeaders)this.armeriaHeaders.build());
        this.future.complete(response);
        logger.debug("{} Response future has been completed with an HttpResponse", (Object)this.ctx);
        return Mono.fromFuture((CompletableFuture)response.whenComplete()).onErrorResume(CancelledSubscriptionException.class, e -> Mono.empty());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("ctx", (Object)this.ctx).add("future", this.future).add("factoryWrapper", this.factoryWrapper).add("headers", (Object)this.armeriaHeaders.build()).toString();
    }
}

