/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.spring.ArmeriaBeanPostProcessor;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;

final class ArmeriaWebServer
implements WebServer {
    private final Server server;
    private final SessionProtocol protocol;
    @Nullable
    private final InetAddress address;
    private int port;
    private final ConfigurableListableBeanFactory beanFactory;
    private boolean isRunning;

    ArmeriaWebServer(Server server, SessionProtocol protocol, @Nullable InetAddress address, int port, ConfigurableListableBeanFactory beanFactory) {
        this.server = Objects.requireNonNull(server, "server");
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.address = address;
        this.beanFactory = Objects.requireNonNull(beanFactory, "beanFactory");
        Preconditions.checkArgument((port >= 0 && port <= 65535 ? 1 : 0) != 0, (String)"port: %s (expected: 0...65535)", (int)port);
        this.port = port;
    }

    public synchronized void start() {
        try {
            if (!this.isRunning) {
                this.server.start().get();
                if (this.port == 0) {
                    Optional<ServerPort> port = this.server.activePorts().values().stream().filter(p -> p.protocols().contains(this.protocol)).filter(p -> this.address == null || Arrays.equals(this.address.getAddress(), p.localAddress().getAddress().getAddress())).findFirst();
                    assert (port.isPresent()) : "the primary port doest not exist.";
                    this.port = port.get().localAddress().getPort();
                }
                this.beanFactory.registerSingleton("server", (Object)this.server);
                ArmeriaBeanPostProcessor beanPostProcessor = new ArmeriaBeanPostProcessor((BeanFactory)this.beanFactory);
                this.beanFactory.addBeanPostProcessor((BeanPostProcessor)beanPostProcessor);
                this.isRunning = true;
            }
        }
        catch (Exception cause) {
            throw new WebServerException("Failed to start " + ArmeriaWebServer.class.getSimpleName() + ". server: " + this.server + ", primary port: " + this.port, Exceptions.peel((Throwable)cause));
        }
    }

    public synchronized void stop() {
        try {
            if (this.isRunning) {
                this.server.stop().get();
                this.isRunning = false;
            }
        }
        catch (Exception cause) {
            throw new WebServerException("Failed to stop " + ArmeriaWebServer.class.getSimpleName(), Exceptions.peel((Throwable)cause));
        }
    }

    public int getPort() {
        return this.port;
    }
}

