/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring;

import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.spring.ArmeriaConfigurationUtil;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import com.linecorp.armeria.spring.ArmeriaServerGracefulShutdownLifecycle;
import com.linecorp.armeria.spring.ArmeriaServerSmartLifecycle;
import com.linecorp.armeria.spring.ArmeriaSettings;
import com.linecorp.armeria.spring.DocServiceConfigurator;
import com.linecorp.armeria.spring.HealthCheckServiceConfigurator;
import com.linecorp.armeria.spring.InternalServices;
import com.linecorp.armeria.spring.MetricCollectingServiceConfigurator;
import io.micrometer.core.instrument.MeterRegistry;
import java.net.InetAddress;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;

public abstract class AbstractArmeriaAutoConfiguration {
    private static final ArmeriaSettings.Port DEFAULT_PORT = new ArmeriaSettings.Port().setPort(8080).setProtocol(SessionProtocol.HTTP);
    private static final String GRACEFUL_SHUTDOWN = "graceful";

    @Bean
    @ConditionalOnMissingBean(value={Server.class})
    public Server armeriaServer(ArmeriaSettings armeriaSettings, InternalServices internalService, Optional<MeterRegistry> meterRegistry, Optional<List<MetricCollectingServiceConfigurator>> metricCollectingServiceConfigurators, Optional<MeterIdPrefixFunction> meterIdPrefixFunction, Optional<List<ArmeriaServerConfigurator>> armeriaServerConfigurators, Optional<List<Consumer<ServerBuilder>>> armeriaServerBuilderConsumers, Optional<List<DependencyInjector>> dependencyInjectors, BeanFactory beanFactory) {
        if (!armeriaServerConfigurators.isPresent() && !armeriaServerBuilderConsumers.isPresent()) {
            throw new IllegalStateException("No services to register, use ArmeriaServerConfigurator or Consumer<ServerBuilder> to configure an Armeria server.");
        }
        ServerBuilder serverBuilder = Server.builder();
        List<ArmeriaSettings.Port> ports = armeriaSettings.getPorts();
        if (ports.isEmpty()) {
            assert (DEFAULT_PORT.getProtocols() != null);
            serverBuilder.port(new ServerPort(DEFAULT_PORT.getPort(), DEFAULT_PORT.getProtocols()));
        }
        ArmeriaConfigurationUtil.configureServerWithArmeriaSettings(serverBuilder, armeriaSettings, internalService, armeriaServerConfigurators.orElse((List<ArmeriaServerConfigurator>)ImmutableList.of()), armeriaServerBuilderConsumers.orElse((List<Consumer<ServerBuilder>>)ImmutableList.of()), meterRegistry.orElse(Flags.meterRegistry()), meterIdPrefixFunction.orElse(MeterIdPrefixFunction.ofDefault((String)"armeria.server")), metricCollectingServiceConfigurators.orElse((List<MetricCollectingServiceConfigurator>)ImmutableList.of()), dependencyInjectors.orElse((List<DependencyInjector>)ImmutableList.of()), beanFactory);
        return serverBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean(value={ArmeriaServerSmartLifecycle.class})
    public SmartLifecycle armeriaServerGracefulShutdownLifecycle(Server server) {
        return new ArmeriaServerGracefulShutdownLifecycle(server);
    }

    @Bean
    public InternalServices internalServices(ArmeriaSettings settings, Optional<MeterRegistry> meterRegistry, Optional<List<HealthChecker>> healthCheckers, Optional<List<HealthCheckServiceConfigurator>> healthCheckServiceConfigurators, Optional<List<DocServiceConfigurator>> docServiceConfigurators, @Value(value="${management.server.port:#{null}}") @Nullable Integer managementServerPort, @Value(value="${management.server.address:#{null}}") @Nullable InetAddress managementServerAddress, @Value(value="${management.server.ssl.enabled:#{false}}") boolean enableManagementServerSsl) {
        return InternalServices.of(settings, meterRegistry.orElse(Flags.meterRegistry()), healthCheckers.orElse((List<HealthChecker>)ImmutableList.of()), healthCheckServiceConfigurators.orElse((List<HealthCheckServiceConfigurator>)ImmutableList.of()), docServiceConfigurators.orElse((List<DocServiceConfigurator>)ImmutableList.of()), managementServerPort, managementServerAddress, enableManagementServerSsl);
    }

    @Bean
    @ConditionalOnProperty(value={"server.shutdown"})
    public ArmeriaServerConfigurator gracefulShutdownServerConfigurator(@Value(value="${server.shutdown}") String shutdown, @Value(value="${spring.lifecycle.timeout-per-shutdown-phase:30s}") Duration duration) {
        if (GRACEFUL_SHUTDOWN.equalsIgnoreCase(shutdown)) {
            return sb -> sb.gracefulShutdownTimeout(duration, duration);
        }
        return sb -> {};
    }
}

