/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring;

import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.spring.ArmeriaServerSmartLifecycle;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArmeriaServerGracefulShutdownLifecycle
implements ArmeriaServerSmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaServerGracefulShutdownLifecycle.class);
    private final Server server;
    private volatile boolean running;

    ArmeriaServerGracefulShutdownLifecycle(Server server) {
        this.server = Objects.requireNonNull(server, "server");
    }

    public void start() {
        ((CompletableFuture)this.server.start().handle((result, t) -> {
            if (t != null) {
                throw new IllegalStateException("Armeria server failed to start", (Throwable)t);
            }
            this.running = true;
            return null;
        })).join();
        logger.info("Armeria server started at ports: {}", (Object)this.server.activePorts());
    }

    public void stop() {
        throw new UnsupportedOperationException("Stop must not be invoked directly");
    }

    public void stop(Runnable callback) {
        this.server.stop().whenComplete((unused, throwable) -> {
            callback.run();
            this.running = false;
        });
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return true;
    }
}

