/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.spring;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import com.linecorp.armeria.internal.spring.ArmeriaConfigurationUtil;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import com.linecorp.armeria.spring.ArmeriaSettings;
import java.util.function.Consumer;

public final class ArmeriaConfigurationSettingsUtil {
    public static void configureSettings(ServerBuilder server, ArmeriaSettings settings) {
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getContextPath(), arg_0 -> ((ServerBuilder)server).baseContextPath(arg_0));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getWorkerGroup(), arg_0 -> ((ServerBuilder)server).workerGroup(arg_0));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getBlockingTaskExecutor(), arg_0 -> ((ServerBuilder)server).blockingTaskExecutor(arg_0));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getMaxNumConnections(), arg_0 -> ((ServerBuilder)server).maxNumConnections(arg_0));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getIdleTimeout(), arg_0 -> ((ServerBuilder)server).idleTimeout(arg_0));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getPingInterval(), arg_0 -> ((ServerBuilder)server).pingInterval(arg_0));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getMaxConnectionAge(), arg_0 -> ((ServerBuilder)server).maxConnectionAge(arg_0));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getMaxNumRequestsPerConnection(), arg_0 -> ((ServerBuilder)server).maxNumRequestsPerConnection(arg_0));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getHttp2InitialConnectionWindowSize(), http2InitialConnectionWindowSize -> server.http2InitialConnectionWindowSize(Ints.saturatedCast((long)ArmeriaConfigurationUtil.parseDataSize(http2InitialConnectionWindowSize))));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getHttp2InitialStreamWindowSize(), http2InitialStreamWindowSize -> server.http2InitialStreamWindowSize(Ints.saturatedCast((long)ArmeriaConfigurationUtil.parseDataSize(http2InitialStreamWindowSize))));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getHttp2MaxStreamsPerConnection(), arg_0 -> ((ServerBuilder)server).http2MaxStreamsPerConnection(arg_0));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getHttp2MaxFrameSize(), http2MaxFrameSize -> server.http2MaxFrameSize(Ints.saturatedCast((long)ArmeriaConfigurationUtil.parseDataSize(http2MaxFrameSize))));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getHttp2MaxHeaderListSize(), http2MaxHeaderListSize -> server.http2MaxHeaderListSize(ArmeriaConfigurationUtil.parseDataSize(http2MaxHeaderListSize)));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getHttp1MaxInitialLineLength(), http1MaxInitialLineLength -> server.http1MaxInitialLineLength(Ints.saturatedCast((long)ArmeriaConfigurationUtil.parseDataSize(http1MaxInitialLineLength))));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getHttp1MaxHeaderSize(), http1MaxHeaderSize -> server.http1MaxHeaderSize(Ints.saturatedCast((long)ArmeriaConfigurationUtil.parseDataSize(http1MaxHeaderSize))));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getHttp1MaxChunkSize(), http1MaxChunkSize -> server.http1MaxChunkSize(Ints.saturatedCast((long)ArmeriaConfigurationUtil.parseDataSize(http1MaxChunkSize))));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getAccessLog(), accessLog -> ArmeriaConfigurationSettingsUtil.configureAccessLog(server, accessLog));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getAccessLogger(), arg_0 -> ((ServerBuilder)server).accessLogger(arg_0));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getRequestTimeout(), arg_0 -> ((ServerBuilder)server).requestTimeout(arg_0));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getMaxRequestLength(), maxRequestLength -> server.maxRequestLength(ArmeriaConfigurationUtil.parseDataSize(maxRequestLength)));
        ArmeriaConfigurationSettingsUtil.configureIfNonNull(settings.getVerboseResponses(), arg_0 -> ((ServerBuilder)server).verboseResponses(arg_0));
    }

    private ArmeriaConfigurationSettingsUtil() {
    }

    private static <T> void configureIfNonNull(@Nullable T nullable, Consumer<T> block) {
        if (nullable != null) {
            block.accept(nullable);
        }
    }

    private static void configureAccessLog(ServerBuilder server, ArmeriaSettings.AccessLog settings) {
        if ("common".equalsIgnoreCase(settings.getType())) {
            server.accessLogWriter(AccessLogWriter.common(), true);
        } else if ("combined".equalsIgnoreCase(settings.getType())) {
            server.accessLogWriter(AccessLogWriter.combined(), true);
        } else if ("disabled".equalsIgnoreCase(settings.getType())) {
            server.accessLogWriter(AccessLogWriter.disabled(), true);
        } else if ("custom".equalsIgnoreCase(settings.getType())) {
            Preconditions.checkArgument((settings.getFormat() != null ? 1 : 0) != 0, (Object)"custom type must have format");
            server.accessLogWriter(AccessLogWriter.custom((String)settings.getFormat()), true);
        }
    }
}

