/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.spring.LocalArmeriaPort;
import com.linecorp.armeria.spring.LocalArmeriaPorts;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ReflectionUtils;

abstract class AbstractArmeriaBeanPostProcessor {
    private final Map<String, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap<String, InjectionMetadata>(256);
    private final Map<SessionProtocol, Integer> portCache = new ConcurrentHashMap<SessionProtocol, Integer>(SessionProtocol.values().length);
    private final List<Integer> portsCache = new CopyOnWriteArrayList<Integer>();
    private final BeanFactory beanFactory;
    @Nullable
    private Server server;

    AbstractArmeriaBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = Objects.requireNonNull(beanFactory, "beanFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InjectionMetadata findLocalArmeriaPortMetadata(String beanName, Class<?> clazz, @Nullable PropertyValues pvs) {
        String cacheKey = !Strings.isNullOrEmpty((String)beanName) ? beanName : clazz.getName();
        InjectionMetadata metadata = this.injectionMetadataCache.get(cacheKey);
        if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
            Map<String, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(cacheKey);
                if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
                    if (metadata != null) {
                        metadata.clear(pvs);
                    }
                    metadata = this.buildLocalArmeriaPortMetadata(clazz);
                    this.injectionMetadataCache.put(cacheKey, metadata);
                }
            }
        }
        assert (metadata != null);
        return metadata;
    }

    private InjectionMetadata buildLocalArmeriaPortMetadata(Class<?> clazz) {
        ArrayList elements = new ArrayList();
        Class<?> targetClass = clazz;
        do {
            ArrayList currElements = new ArrayList();
            ReflectionUtils.doWithLocalFields(targetClass, field -> {
                if (field.isAnnotationPresent(LocalArmeriaPort.class)) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        throw new IllegalStateException("LocalArmeriaPort annotation is not supported on a static field: " + field.getName());
                    }
                    currElements.add(new LocalArmeriaPortElement(field, field, null));
                } else if (field.isAnnotationPresent(LocalArmeriaPorts.class)) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        throw new IllegalStateException("LocalArmeriaPorts annotation is not supported on a static field: " + field.getName());
                    }
                    currElements.add(new LocalArmeriaPortsElement(field, null));
                }
            });
            ReflectionUtils.doWithLocalMethods(targetClass, method -> {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, (Method)bridgedMethod)) {
                    return;
                }
                if (bridgedMethod.isAnnotationPresent(LocalArmeriaPort.class)) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("LocalArmeriaPort annotation is not supported on a static method: " + method.getName());
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, (Class)clazz);
                    currElements.add(new LocalArmeriaPortElement(method, bridgedMethod, pd));
                } else if (bridgedMethod.isAnnotationPresent(LocalArmeriaPorts.class)) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("LocalArmeriaPorts annotation is not supported on a static method: " + method.getName());
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, (Class)clazz);
                    currElements.add(new LocalArmeriaPortsElement(method, pd));
                }
            });
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return new InjectionMetadata(clazz, elements);
    }

    private void setServer(Server server) {
        this.server = Objects.requireNonNull(server, "server");
    }

    @Nullable
    private Server getServer() {
        return this.server;
    }

    private final class LocalArmeriaPortElement
    extends InjectionMetadata.InjectedElement {
        private final int port;

        private LocalArmeriaPortElement(Member member, @Nullable AnnotatedElement ae, PropertyDescriptor pd) {
            Integer port;
            super(member, pd);
            LocalArmeriaPort localArmeriaPort = ae.getAnnotation(LocalArmeriaPort.class);
            SessionProtocol protocol = localArmeriaPort.value();
            Server server = AbstractArmeriaBeanPostProcessor.this.getServer();
            if (server == null) {
                server = (Server)AbstractArmeriaBeanPostProcessor.this.beanFactory.getBean(Server.class);
                AbstractArmeriaBeanPostProcessor.this.setServer(server);
            }
            if ((port = AbstractArmeriaBeanPostProcessor.this.portCache.get(protocol)) == null) {
                port = server.activeLocalPort(protocol);
                AbstractArmeriaBeanPostProcessor.this.portCache.put(protocol, port);
            }
            this.port = port;
        }

        protected Object getResourceToInject(Object target, @Nullable String requestingBeanName) {
            return this.port;
        }
    }

    private final class LocalArmeriaPortsElement
    extends InjectionMetadata.InjectedElement {
        private final List<Integer> ports;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalArmeriaPortsElement(@Nullable Member member, PropertyDescriptor pd) {
            super(member, pd);
            Server server = AbstractArmeriaBeanPostProcessor.this.getServer();
            if (server == null) {
                server = (Server)AbstractArmeriaBeanPostProcessor.this.beanFactory.getBean(Server.class);
                AbstractArmeriaBeanPostProcessor.this.setServer(server);
            }
            ImmutableList.Builder ports = ImmutableList.builder();
            if (AbstractArmeriaBeanPostProcessor.this.portsCache.isEmpty()) {
                List<Integer> list = AbstractArmeriaBeanPostProcessor.this.portsCache;
                synchronized (list) {
                    if (AbstractArmeriaBeanPostProcessor.this.portsCache.isEmpty()) {
                        ports.addAll((Iterable)server.activePorts().values().stream().map(p -> p.localAddress().getPort()).collect(ImmutableList.toImmutableList()));
                        AbstractArmeriaBeanPostProcessor.this.portsCache.addAll((Collection<Integer>)ports.build());
                    } else {
                        ports.addAll(AbstractArmeriaBeanPostProcessor.this.portsCache);
                    }
                }
            } else {
                ports.addAll(AbstractArmeriaBeanPostProcessor.this.portsCache);
            }
            this.ports = ports.build();
        }

        protected Object getResourceToInject(Object target, @Nullable String requestingBeanName) {
            return this.ports;
        }
    }
}

