/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.spring;

import com.linecorp.armeria.internal.spring.CustomAliasX509ExtendedKeyManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;

final class CustomAliasKeyManagerFactory
extends KeyManagerFactory {
    CustomAliasKeyManagerFactory(final KeyManagerFactory delegate, final String alias) {
        super(new KeyManagerFactorySpi(){

            @Override
            protected void engineInit(KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
                delegate.init(ks, password);
            }

            @Override
            protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
                delegate.init(spec);
            }

            @Override
            protected KeyManager[] engineGetKeyManagers() {
                KeyManager[] keyManagers = (KeyManager[])delegate.getKeyManagers().clone();
                for (int i = 0; i < keyManagers.length; ++i) {
                    if (!(keyManagers[i] instanceof X509ExtendedKeyManager)) continue;
                    X509ExtendedKeyManager keyManager = (X509ExtendedKeyManager)keyManagers[i];
                    keyManagers[i] = new CustomAliasX509ExtendedKeyManager(keyManager, alias);
                }
                return keyManagers;
            }
        }, delegate.getProvider(), delegate.getAlgorithm());
    }
}

