/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.spring.web.reactive.ChannelSendOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class AbstractServerHttpResponse
implements ServerHttpResponse {
    private final DataBufferFactory dataBufferFactory;
    private final HttpHeaders headers;
    private final MultiValueMap<String, ResponseCookie> cookies;
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final List<Supplier<? extends Mono<Void>>> commitActions = new ArrayList<Supplier<? extends Mono<Void>>>(4);
    @Nullable
    private HttpHeaders readOnlyHeaders;

    AbstractServerHttpResponse(DataBufferFactory dataBufferFactory) {
        this(dataBufferFactory, new HttpHeaders());
    }

    AbstractServerHttpResponse(DataBufferFactory dataBufferFactory, HttpHeaders headers) {
        Objects.requireNonNull(dataBufferFactory, "DataBufferFactory must not be null");
        Objects.requireNonNull(headers, "HttpHeaders must not be null");
        this.dataBufferFactory = dataBufferFactory;
        this.headers = headers;
        this.cookies = new LinkedMultiValueMap();
    }

    public final DataBufferFactory bufferFactory() {
        return this.dataBufferFactory;
    }

    final State state() {
        State state = this.state.get();
        assert (state != null);
        return state;
    }

    public HttpHeaders getHeaders() {
        if (this.readOnlyHeaders != null) {
            return this.readOnlyHeaders;
        }
        if (this.state.get() == State.COMMITTED) {
            this.readOnlyHeaders = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.headers);
            return this.readOnlyHeaders;
        }
        return this.headers;
    }

    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.state.get() == State.COMMITTED ? CollectionUtils.unmodifiableMultiValueMap(this.cookies) : this.cookies;
    }

    public void addCookie(ResponseCookie cookie) {
        Objects.requireNonNull(cookie, "ResponseCookie must not be null");
        if (this.state.get() == State.COMMITTED) {
            throw new IllegalStateException("Can't add the cookie " + String.valueOf(cookie) + "because the HTTP response has already been committed");
        }
        this.getCookies().add((Object)cookie.getName(), (Object)cookie);
    }

    public abstract <T> T getNativeResponse();

    public void beforeCommit(Supplier<? extends Mono<Void>> action) {
        this.commitActions.add(action);
    }

    public boolean isCommitted() {
        State state = this.state.get();
        return state != State.NEW && state != State.COMMIT_ACTION_FAILED;
    }

    public final Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        if (body instanceof Mono) {
            return ((Mono)body).flatMap(buffer -> {
                this.touchDataBuffer((DataBuffer)buffer);
                AtomicBoolean subscribed = new AtomicBoolean();
                return this.doCommit(() -> {
                    try {
                        return this.writeWithInternal((Publisher<? extends DataBuffer>)Mono.just((Object)buffer).doOnSubscribe(s -> subscribed.set(true)).doOnDiscard(DataBuffer.class, DataBufferUtils::release));
                    }
                    catch (Throwable ex) {
                        return Mono.error((Throwable)ex);
                    }
                }).doOnError(ex -> DataBufferUtils.release((DataBuffer)buffer)).doOnCancel(() -> {
                    if (!subscribed.get()) {
                        DataBufferUtils.release((DataBuffer)buffer);
                    }
                });
            }).doOnError(t -> this.getHeaders().clearContentHeaders()).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
        }
        return new ChannelSendOperator<DataBuffer>(body, inner -> this.doCommit(() -> this.writeWithInternal((Publisher<? extends DataBuffer>)inner))).doOnError(t -> this.getHeaders().clearContentHeaders());
    }

    public final Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return new ChannelSendOperator<Publisher<? extends DataBuffer>>(body, inner -> this.doCommit(() -> this.writeAndFlushWithInternal((Publisher<? extends Publisher<? extends DataBuffer>>)inner))).doOnError(t -> this.getHeaders().clearContentHeaders());
    }

    public Mono<Void> setComplete() {
        return !this.isCommitted() ? this.doCommit(null) : Mono.empty();
    }

    protected Mono<Void> doCommit() {
        return this.doCommit(null);
    }

    protected Mono<Void> doCommit(@Nullable Supplier<? extends Mono<Void>> writeAction) {
        Flux allActions = Flux.empty();
        if (this.state.compareAndSet(State.NEW, State.COMMITTING)) {
            if (!this.commitActions.isEmpty()) {
                allActions = Flux.concat((Publisher)Flux.fromIterable(this.commitActions).map(Supplier::get)).doOnError(ex -> {
                    if (this.state.compareAndSet(State.COMMITTING, State.COMMIT_ACTION_FAILED)) {
                        this.getHeaders().clearContentHeaders();
                    }
                });
            }
        } else if (!this.state.compareAndSet(State.COMMIT_ACTION_FAILED, State.COMMITTING)) {
            return Mono.empty();
        }
        allActions = allActions.concatWith((Publisher)Mono.fromRunnable(() -> {
            this.applyStatusCode();
            this.applyHeaders();
            this.applyCookies();
            this.state.set(State.COMMITTED);
        }));
        if (writeAction != null) {
            allActions = allActions.concatWith((Publisher)writeAction.get());
        }
        return allActions.then();
    }

    protected abstract Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> var1);

    protected abstract Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> var1);

    protected abstract void applyStatusCode();

    protected abstract void applyHeaders();

    protected abstract void applyCookies();

    protected void touchDataBuffer(DataBuffer buffer) {
    }

    @Nullable
    abstract Integer getStatusCode0();

    static enum State {
        NEW,
        COMMITTING,
        COMMIT_ACTION_FAILED,
        COMMITTED;

    }
}

