/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.spring.internal.common.DataBufferFactoryWrapper;
import com.linecorp.armeria.spring.web.reactive.ArmeriaClientConfigurator;
import com.linecorp.armeria.spring.web.reactive.ArmeriaClientHttpConnector;
import com.linecorp.armeria.spring.web.reactive.DataBufferFactoryWrapperConfiguration;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.web.reactive.function.client.WebClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ConditionalOnClass(value={WebClient.Builder.class})
@ConditionalOnMissingBean(value={ClientHttpConnector.class})
@Import(value={WebClientAutoConfiguration.class, DataBufferFactoryWrapperConfiguration.class})
public class ArmeriaClientAutoConfiguration {
    @Bean
    public ClientHttpConnector clientHttpConnector(List<ArmeriaClientConfigurator> customizer, DataBufferFactoryWrapper<?> factoryWrapper) {
        return new ArmeriaClientHttpConnector(customizer, factoryWrapper);
    }

    @Bean
    public WebClientCustomizer webClientCustomizer(ClientHttpConnector clientHttpConnector) {
        return builder -> builder.clientConnector(clientHttpConnector);
    }
}

