/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientBuilder;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SplitHttpResponse;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.spring.internal.client.ArmeriaClientHttpRequest;
import com.linecorp.armeria.spring.internal.client.ArmeriaClientHttpResponse;
import com.linecorp.armeria.spring.internal.common.DataBufferFactoryWrapper;
import com.linecorp.armeria.spring.web.reactive.ArmeriaClientConfigurator;
import com.linecorp.armeria.spring.web.reactive.ArmeriaHttpResponseBodyStream;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import reactor.core.publisher.Mono;

final class ArmeriaClientHttpConnector
implements ClientHttpConnector {
    private final WebClient webClient;
    private final DataBufferFactoryWrapper<?> factoryWrapper;

    @VisibleForTesting
    ArmeriaClientHttpConnector(ArmeriaClientConfigurator configurator) {
        this((Iterable<ArmeriaClientConfigurator>)ImmutableList.of((Object)Objects.requireNonNull(configurator, "configurator")), DataBufferFactoryWrapper.DEFAULT);
    }

    ArmeriaClientHttpConnector(Iterable<ArmeriaClientConfigurator> configurators, DataBufferFactoryWrapper<?> factoryWrapper) {
        this.webClient = ArmeriaClientHttpConnector.buildWebClient(Objects.requireNonNull(configurators, "configurators"));
        this.factoryWrapper = Objects.requireNonNull(factoryWrapper, "factoryWrapper");
    }

    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        try {
            Objects.requireNonNull(method, "method");
            Objects.requireNonNull(uri, "uri");
            Objects.requireNonNull(requestCallback, "requestCallback");
            ArmeriaClientHttpRequest request = this.createRequest(method, uri);
            return requestCallback.apply((ClientHttpRequest)request).then(Mono.fromFuture((CompletableFuture)request.future().thenCompose(this::createResponse)));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Mono.error((Throwable)e);
        }
    }

    private static WebClient buildWebClient(Iterable<ArmeriaClientConfigurator> configurators) {
        WebClientBuilder builder = WebClient.builder();
        configurators.forEach(c -> c.configure(builder));
        return builder.build();
    }

    private ArmeriaClientHttpRequest createRequest(HttpMethod method, URI uri) {
        String path = uri.getRawPath();
        String query = uri.getRawQuery();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (String)"path is undefined: %s", (Object)uri);
        String pathAndQuery = Strings.isNullOrEmpty((String)query) ? path : path + "?" + query;
        return new ArmeriaClientHttpRequest(this.webClient, method, pathAndQuery, uri, this.factoryWrapper, null);
    }

    private CompletableFuture<ArmeriaClientHttpResponse> createResponse(HttpResponse response) {
        ArmeriaHttpResponseBodyStream bodyStream = new ArmeriaHttpResponseBodyStream(response, response.defaultSubscriberExecutor());
        return bodyStream.headers().thenApply(headers -> new ArmeriaClientHttpResponse(headers, (SplitHttpResponse)bodyStream, this.factoryWrapper));
    }
}

