/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.spring.internal.common.DataBufferFactoryWrapper;
import com.linecorp.armeria.spring.web.reactive.ArmeriaServerHttpRequest;
import com.linecorp.armeria.spring.web.reactive.ArmeriaServerHttpResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import reactor.core.publisher.Mono;

final class ArmeriaHttpHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaHttpHandlerAdapter.class);
    private final HttpHandler httpHandler;
    private final DataBufferFactoryWrapper<?> factoryWrapper;

    ArmeriaHttpHandlerAdapter(HttpHandler httpHandler, DataBufferFactoryWrapper<?> factoryWrapper) {
        this.httpHandler = Objects.requireNonNull(httpHandler, "httpHandler");
        this.factoryWrapper = Objects.requireNonNull(factoryWrapper, "factoryWrapper");
    }

    Mono<Void> handle(ServiceRequestContext ctx, HttpRequest req, CompletableFuture<HttpResponse> future, @Nullable String serverHeader) {
        ArmeriaServerHttpRequest convertedRequest;
        try {
            convertedRequest = new ArmeriaServerHttpRequest(ctx, req, this.factoryWrapper);
        }
        catch (Exception e) {
            String path = req.path();
            logger.warn("{} Invalid request path: {}", new Object[]{ctx, path, e});
            future.complete(HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)(String.valueOf(HttpStatus.BAD_REQUEST) + "\nInvalid request path: " + path)));
            return Mono.empty();
        }
        ArmeriaServerHttpResponse convertedResponse = new ArmeriaServerHttpResponse(ctx, future, this.factoryWrapper, serverHeader);
        return this.httpHandler.handle((ServerHttpRequest)convertedRequest, (ServerHttpResponse)convertedResponse).doOnSuccess(unused -> convertedResponse.setComplete().subscribe()).doOnError(cause -> {
            logger.debug("{} Failed to handle a request", (Object)ctx, cause);
            convertedResponse.setComplete((Throwable)cause).subscribe();
        }).doOnCancel(() -> {
            RequestLog requestLog = ctx.log().getIfAvailable(new RequestLogProperty[]{RequestLogProperty.RESPONSE_HEADERS});
            if (requestLog != null) {
                convertedResponse.setRawStatusCode(requestLog.responseStatus().code());
                convertedResponse.setComplete().subscribe();
            }
        });
    }
}

