/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.spring.ArmeriaSettings;
import com.linecorp.armeria.spring.DocServiceConfigurator;
import com.linecorp.armeria.spring.HealthCheckServiceConfigurator;
import com.linecorp.armeria.spring.InternalServices;
import com.linecorp.armeria.spring.web.reactive.ArmeriaReactiveWebServerFactory;
import com.linecorp.armeria.spring.web.reactive.DataBufferFactoryWrapperConfiguration;
import io.micrometer.core.instrument.MeterRegistry;
import java.net.InetAddress;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@AutoConfigureOrder(value=-2147483648)
@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={Server.class})
@EnableConfigurationProperties(value={ServerProperties.class, ArmeriaSettings.class})
@Import(value={DataBufferFactoryWrapperConfiguration.class})
public class ArmeriaReactiveWebServerFactoryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ArmeriaReactiveWebServerFactory.class})
    public ArmeriaReactiveWebServerFactory armeriaReactiveWebServerFactory(ConfigurableListableBeanFactory beanFactory, Environment environment) {
        return new ArmeriaReactiveWebServerFactory(beanFactory, environment);
    }

    @Bean
    public InternalServices internalServices(ArmeriaSettings settings, Optional<MeterRegistry> meterRegistry, ObjectProvider<HealthChecker> healthCheckers, ObjectProvider<HealthCheckServiceConfigurator> healthCheckServiceConfigurators, ObjectProvider<DocServiceConfigurator> docServiceConfigurators, @Value(value="${management.server.port:#{null}}") @Nullable Integer managementServerPort, @Value(value="${management.server.address:#{null}}") @Nullable InetAddress managementServerAddress, @Value(value="${management.server.ssl.enabled:#{false}}") boolean enableManagementServerSsl) {
        return InternalServices.of(settings, meterRegistry.orElse(Flags.meterRegistry()), (List)healthCheckers.orderedStream().collect(ImmutableList.toImmutableList()), (List)healthCheckServiceConfigurators.orderedStream().collect(ImmutableList.toImmutableList()), (List)docServiceConfigurators.orderedStream().collect(ImmutableList.toImmutableList()), managementServerPort, managementServerAddress, enableManagementServerSsl);
    }
}

