/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestTarget;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.spring.internal.common.DataBufferFactoryWrapper;
import com.linecorp.armeria.spring.web.reactive.AbstractServerHttpRequestVersionSpecific;
import com.linecorp.armeria.spring.web.reactive.DefaultSslInfo;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLSession;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

final class ArmeriaServerHttpRequest
extends AbstractServerHttpRequestVersionSpecific {
    private final ServiceRequestContext ctx;
    private final HttpRequest req;
    private final Flux<DataBuffer> body;

    ArmeriaServerHttpRequest(ServiceRequestContext ctx, HttpRequest req, DataBufferFactoryWrapper<?> factoryWrapper) {
        super(HttpMethod.valueOf((String)ctx.method().name()), ArmeriaServerHttpRequest.uri(ctx, req), null, (MultiValueMap<String, String>)ArmeriaServerHttpRequest.springHeaders(req.headers()));
        this.ctx = Objects.requireNonNull(ctx, "ctx");
        this.req = req;
        this.body = Flux.from((Publisher)req).cast(HttpData.class).map(arg_0 -> factoryWrapper.toDataBuffer(arg_0)).publishOn(Schedulers.fromExecutor((Executor)ctx.eventLoop()));
    }

    private static HttpHeaders springHeaders(RequestHeaders headers) {
        HttpHeaders springHeaders = new HttpHeaders();
        ArmeriaHttpUtil.toHttp1Headers((com.linecorp.armeria.common.HttpHeaders)headers, (Object)springHeaders, (output, key, value) -> output.add(key.toString(), value));
        return springHeaders;
    }

    private static URI uri(ServiceRequestContext ctx, HttpRequest req) {
        String scheme = req.scheme();
        String authority = req.authority();
        assert (scheme != null);
        assert (authority != null);
        RequestTarget requestTarget = ctx.routingContext().requestTarget();
        Object path = requestTarget.maybePathWithMatrixVariables();
        if (requestTarget.query() != null) {
            path = (String)path + "?" + requestTarget.query();
        }
        return URI.create(scheme + "://" + authority + (String)path);
    }

    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        List values = this.req.headers().getAll((CharSequence)HttpHeaderNames.COOKIE);
        values.stream().map(arg_0 -> ((ServerCookieDecoder)ServerCookieDecoder.LAX).decode(arg_0)).flatMap(Collection::stream).forEach(arg_0 -> ArmeriaServerHttpRequest.lambda$initCookies$1((MultiValueMap)cookies, arg_0));
        return cookies;
    }

    protected String initId() {
        return this.ctx.id().text();
    }

    @Nullable
    protected SslInfo initSslInfo() {
        SSLSession session = this.ctx.sslSession();
        return session != null ? new DefaultSslInfo(session) : null;
    }

    public <T> T getNativeRequest() {
        return (T)this.req;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.req.method().name());
    }

    public String getMethodValue() {
        return this.req.method().name();
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public InetSocketAddress getLocalAddress() {
        return this.ctx.localAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.ctx.remoteAddress();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("ctx", (Object)this.ctx).add("req", (Object)this.req).toString();
    }

    private static /* synthetic */ void lambda$initCookies$1(MultiValueMap cookies, Cookie c) {
        cookies.add((Object)c.name(), (Object)new HttpCookie(c.name(), c.value()));
    }
}

