/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.common.annotation.Nullable;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLSession;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.util.Assert;

final class DefaultSslInfo
implements SslInfo {
    @Nullable
    private final String sessionId;
    @Nullable
    private final X509Certificate[] peerCertificates;

    DefaultSslInfo(SSLSession session) {
        Assert.notNull((Object)session, (String)"SSLSession is required");
        this.sessionId = DefaultSslInfo.initSessionId(session);
        this.peerCertificates = DefaultSslInfo.initCertificates(session);
    }

    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    @Nullable
    public X509Certificate[] getPeerCertificates() {
        return this.peerCertificates;
    }

    @Nullable
    private static String initSessionId(SSLSession session) {
        byte[] bytes = session.getId();
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String digit = Integer.toHexString(b);
            if (digit.length() < 2) {
                sb.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            sb.append(digit);
        }
        return sb.toString();
    }

    @Nullable
    private static X509Certificate[] initCertificates(SSLSession session) {
        Certificate[] certificates;
        try {
            certificates = session.getPeerCertificates();
        }
        catch (Throwable ex) {
            return null;
        }
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(certificates.length);
        for (Certificate certificate : certificates) {
            if (!(certificate instanceof X509Certificate)) continue;
            result.add((X509Certificate)certificate);
        }
        return !result.isEmpty() ? result.toArray(new X509Certificate[0]) : null;
    }
}

