/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.web.reactive;

import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.spring.ArmeriaConfigurationUtil;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.spring.Ssl;
import com.linecorp.armeria.spring.web.reactive.ArmeriaReactiveWebServerFactory;
import java.security.KeyStore;
import java.util.function.Supplier;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.server.WebServerSslBundle;

final class TlsUtil {
    static void configureTls(ServerBuilder sb, Ssl ssl, ArmeriaReactiveWebServerFactory factory) {
        Supplier<KeyStore> trustStoreSupplier;
        Supplier<KeyStore> keyStoreSupplier;
        if (!ssl.isEnabled()) {
            return;
        }
        org.springframework.boot.web.server.Ssl springSsl = factory.getSsl();
        if (springSsl.getCertificate() != null && springSsl.getCertificatePrivateKey() != null || ssl.getKeyStore() != null || "PKCS11".equals(ssl.getKeyStoreType())) {
            SslBundle sslBundle = WebServerSslBundle.get((org.springframework.boot.web.server.Ssl)springSsl, (SslBundles)factory.getSslBundles());
            keyStoreSupplier = () -> {
                try {
                    return sslBundle.getStores().getKeyStore();
                }
                catch (Exception e) {
                    return (KeyStore)Exceptions.throwUnsafely((Throwable)e);
                }
            };
            trustStoreSupplier = () -> {
                try {
                    return sslBundle.getStores().getTrustStore();
                }
                catch (Exception e) {
                    return (KeyStore)Exceptions.throwUnsafely((Throwable)e);
                }
            };
        } else {
            keyStoreSupplier = null;
            trustStoreSupplier = null;
        }
        ArmeriaConfigurationUtil.configureTls(sb, ssl, keyStoreSupplier, trustStoreSupplier);
    }

    private TlsUtil() {
    }
}

