/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.RequestOptionsBuilder;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SplitHttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.spring.client.ArmeriaHttpExchangeAdapterBuilder;
import com.linecorp.armeria.spring.client.RequestAttributeAccess;
import com.linecorp.armeria.spring.client.StatusHandler;
import com.linecorp.armeria.spring.internal.client.ArmeriaClientHttpRequest;
import com.linecorp.armeria.spring.internal.client.ArmeriaClientHttpResponse;
import com.linecorp.armeria.spring.internal.common.DataBufferFactoryWrapper;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.service.invoker.AbstractReactorHttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.ReactiveHttpRequestValues;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@UnstableApi
public final class ArmeriaHttpExchangeAdapter
extends AbstractReactorHttpExchangeAdapter {
    private final WebClient webClient;
    private final ExchangeStrategies exchangeStrategies;
    private final UriBuilderFactory uriBuilderFactory = new DefaultUriBuilderFactory();
    @Nullable
    private final StatusHandler statusHandler;

    public static ArmeriaHttpExchangeAdapter of(WebClient webClient) {
        return ArmeriaHttpExchangeAdapter.builder(webClient).build();
    }

    public static ArmeriaHttpExchangeAdapterBuilder builder(WebClient webClient) {
        return new ArmeriaHttpExchangeAdapterBuilder(webClient);
    }

    ArmeriaHttpExchangeAdapter(WebClient webClient, ExchangeStrategies exchangeStrategies, @Nullable StatusHandler statusHandler) {
        this.webClient = webClient;
        this.exchangeStrategies = exchangeStrategies;
        this.statusHandler = statusHandler;
    }

    public Mono<Void> exchangeForMono(HttpRequestValues requestValues) {
        return this.execute(requestValues).flatMap(ClientResponse::releaseBody);
    }

    public Mono<HttpHeaders> exchangeForHeadersMono(HttpRequestValues requestValues) {
        return this.execute(requestValues).map(response -> response.headers().asHttpHeaders());
    }

    public <T> Mono<T> exchangeForBodyMono(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.execute(requestValues).flatMap(response -> response.bodyToMono(bodyType));
    }

    public <T> Flux<T> exchangeForBodyFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.execute(requestValues).flatMapMany(response -> response.bodyToFlux(bodyType));
    }

    public Mono<ResponseEntity<Void>> exchangeForBodilessEntityMono(HttpRequestValues requestValues) {
        return this.execute(requestValues).flatMap(ClientResponse::toBodilessEntity);
    }

    public <T> Mono<ResponseEntity<T>> exchangeForEntityMono(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.execute(requestValues).flatMap(response -> response.toEntity(bodyType));
    }

    public <T> Mono<ResponseEntity<Flux<T>>> exchangeForEntityFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.execute(requestValues).map(response -> {
            Flux body = response.bodyToFlux(bodyType);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)response.statusCode()).headers(response.headers().asHttpHeaders())).body((Object)body);
        });
    }

    public boolean supportsRequestAttributes() {
        return true;
    }

    private Mono<ClientResponse> execute(HttpRequestValues requestValues) {
        RequestOptions requestOptions;
        URI uri;
        if (requestValues.getUri() != null) {
            uri = requestValues.getUri();
        } else {
            String uriTemplate = requestValues.getUriTemplate();
            if (uriTemplate != null) {
                UriBuilderFactory uriBuilderFactory = requestValues.getUriBuilderFactory();
                Map uriVariables = requestValues.getUriVariables();
                uri = uriBuilderFactory != null ? uriBuilderFactory.expand(uriTemplate, uriVariables) : this.uriBuilderFactory.expand(uriTemplate, uriVariables);
            } else {
                throw new IllegalStateException("Neither full URL nor URI template");
            }
        }
        Map attributes = requestValues.getAttributes();
        if (attributes.isEmpty()) {
            requestOptions = null;
        } else {
            RequestOptionsBuilder requestOptionsBuilder = RequestOptions.builder();
            RequestAttributeAccess.set(requestOptionsBuilder, attributes);
            requestOptions = requestOptionsBuilder.build();
        }
        String path = uri.getRawPath();
        String query = uri.getRawQuery();
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (String)"path is undefined: %s", (Object)uri);
        String pathAndQuery = Strings.isNullOrEmpty((String)query) ? path : path + "?" + query;
        HttpMethod httpMethod = requestValues.getHttpMethod();
        Preconditions.checkArgument((httpMethod != null ? 1 : 0) != 0, (String)"HTTP method is undefined. requestValues: %s", (Object)requestValues);
        ArmeriaClientHttpRequest request = new ArmeriaClientHttpRequest(this.webClient, httpMethod, pathAndQuery, uri, DataBufferFactoryWrapper.DEFAULT, requestOptions);
        Mono response = Mono.fromFuture(request.future());
        return ArmeriaHttpExchangeAdapter.toClientRequest(requestValues, httpMethod, uri).writeTo((ClientHttpRequest)request, this.exchangeStrategies).then(response).flatMap(res -> {
            ClientRequestContext context = request.context();
            assert (context != null);
            return this.toClientResponse((HttpResponse)res, context);
        });
    }

    private static <T> ClientRequest toClientRequest(HttpRequestValues requestValues, HttpMethod httpMethod, URI uri) {
        ReactiveHttpRequestValues reactiveRequestValues;
        Publisher body;
        ClientRequest.Builder builder = ClientRequest.create((HttpMethod)httpMethod, (URI)uri).headers(headers -> headers.addAll((MultiValueMap)requestValues.getHeaders())).cookies(cookies -> cookies.addAll(requestValues.getCookies()));
        Object bodyValue = requestValues.getBodyValue();
        if (bodyValue != null) {
            builder.body(BodyInserters.fromValue((Object)bodyValue));
        } else if (requestValues instanceof ReactiveHttpRequestValues && (body = (reactiveRequestValues = (ReactiveHttpRequestValues)requestValues).getBodyPublisher()) != null) {
            ParameterizedTypeReference elementType = reactiveRequestValues.getBodyPublisherElementType();
            Objects.requireNonNull(elementType, "Publisher body element type is required");
            builder.body(body, elementType);
        }
        return builder.build();
    }

    private Mono<ClientResponse> toClientResponse(HttpResponse response, ClientRequestContext ctx) {
        SplitHttpResponse splitResponse = response.split();
        return Mono.fromFuture((CompletableFuture)splitResponse.headers()).flatMap(headers -> {
            Throwable cause;
            if (this.statusHandler != null && (cause = this.statusHandler.handle(ctx, headers.status())) != null) {
                splitResponse.body().subscribe();
                return Mono.error((Throwable)cause);
            }
            ArmeriaClientHttpResponse httpResponse = new ArmeriaClientHttpResponse((ResponseHeaders)headers, splitResponse, DataBufferFactoryWrapper.DEFAULT);
            HttpStatusCode statusCode = HttpStatusCode.valueOf((int)httpResponse.getRawStatusCode());
            ClientResponse clientResponse = ClientResponse.create((HttpStatusCode)statusCode, (ExchangeStrategies)this.exchangeStrategies).cookies(cookies -> cookies.addAll(httpResponse.getCookies())).headers(headers0 -> headers0.addAll((MultiValueMap)httpResponse.getHeaders())).body(httpResponse.getBody()).build();
            return Mono.just((Object)clientResponse);
        });
    }
}

