/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.client;

import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.spring.client.ArmeriaHttpExchangeAdapter;
import com.linecorp.armeria.spring.client.StatusHandler;
import java.util.Objects;
import org.springframework.web.reactive.function.client.ExchangeStrategies;

@UnstableApi
public final class ArmeriaHttpExchangeAdapterBuilder {
    private final WebClient webClient;
    private ExchangeStrategies exchangeStrategies = ExchangeStrategies.withDefaults();
    @Nullable
    private StatusHandler statusHandler;

    ArmeriaHttpExchangeAdapterBuilder(WebClient webClient) {
        this.webClient = Objects.requireNonNull(webClient, "webClient");
    }

    public ArmeriaHttpExchangeAdapterBuilder exchangeStrategies(ExchangeStrategies exchangeStrategies) {
        Objects.requireNonNull(exchangeStrategies, "exchangeStrategies");
        this.exchangeStrategies = exchangeStrategies;
        return this;
    }

    public ArmeriaHttpExchangeAdapterBuilder statusHandler(StatusHandler statusHandler) {
        Objects.requireNonNull(statusHandler, "statusHandler");
        this.statusHandler = this.statusHandler == null ? statusHandler : this.statusHandler.orElse(statusHandler);
        return this;
    }

    public ArmeriaHttpExchangeAdapter build() {
        return new ArmeriaHttpExchangeAdapter(this.webClient, this.exchangeStrategies, this.statusHandler);
    }
}

