/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.internal.client;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SplitHttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.spring.internal.common.DataBufferFactoryWrapper;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

public final class ArmeriaClientHttpResponse
implements ClientHttpResponse {
    private final com.linecorp.armeria.common.HttpStatus status;
    private final ResponseHeaders headers;
    private final Flux<DataBuffer> body;
    @Nullable
    private MultiValueMap<String, ResponseCookie> cookies;
    @Nullable
    private HttpHeaders httpHeaders;

    public ArmeriaClientHttpResponse(ResponseHeaders headers, SplitHttpResponse response, DataBufferFactoryWrapper<?> factoryWrapper) {
        this.headers = Objects.requireNonNull(headers, "headers");
        this.status = headers.status();
        this.body = Flux.from((Publisher)response.body()).map(factoryWrapper::toDataBuffer);
    }

    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf((int)this.status.code());
    }

    public int getRawStatusCode() {
        return this.status.code();
    }

    public MultiValueMap<String, ResponseCookie> getCookies() {
        MultiValueMap<String, ResponseCookie> cookies = this.cookies;
        if (cookies != null) {
            return cookies;
        }
        this.cookies = this.initCookies();
        return this.cookies;
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public HttpHeaders getHeaders() {
        HttpHeaders httpHeaders = this.httpHeaders;
        if (httpHeaders != null) {
            return httpHeaders;
        }
        this.httpHeaders = new HttpHeaders();
        ArmeriaHttpUtil.toHttp1Headers((com.linecorp.armeria.common.HttpHeaders)this.headers, (Object)this.httpHeaders, (output, key, value) -> output.add(key.toString(), value));
        return this.httpHeaders;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("status", (Object)this.status).add("headers", (Object)this.headers).add("cookies", this.cookies).toString();
    }

    private MultiValueMap<String, ResponseCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        this.headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE).stream().map(arg_0 -> ((ClientCookieDecoder)ClientCookieDecoder.LAX).decode(arg_0)).forEach(arg_0 -> ArmeriaClientHttpResponse.lambda$initCookies$1((MultiValueMap)cookies, arg_0));
        return cookies;
    }

    private static /* synthetic */ void lambda$initCookies$1(MultiValueMap cookies, Cookie c) {
        cookies.add((Object)c.name(), (Object)ResponseCookie.from((String)c.name(), (String)c.value()).maxAge(c.maxAge()).domain(c.domain()).path(c.path()).secure(c.isSecure()).httpOnly(c.isHttpOnly()).build());
    }
}

