/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.spring.internal.common;

import com.linecorp.armeria.common.HttpData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.core.io.buffer.PooledDataBuffer;

public final class DataBufferFactoryWrapper<T extends DataBufferFactory> {
    public static final DataBufferFactoryWrapper<NettyDataBufferFactory> DEFAULT = new DataBufferFactoryWrapper<NettyDataBufferFactory>(new NettyDataBufferFactory((ByteBufAllocator)PooledByteBufAllocator.DEFAULT));
    private final T delegate;
    private final Function<HttpData, DataBuffer> converter;

    public DataBufferFactoryWrapper(T delegate) {
        this.delegate = (DataBufferFactory)Objects.requireNonNull(delegate, "delegate");
        this.converter = delegate instanceof NettyDataBufferFactory ? this::withNettyDataBufferFactory : this::withDataBufferFactory;
    }

    public T delegate() {
        return this.delegate;
    }

    public HttpData toHttpData(DataBuffer dataBuffer) {
        if (dataBuffer instanceof NettyDataBuffer) {
            return HttpData.wrap((ByteBuf)((NettyDataBuffer)dataBuffer).getNativeBuffer());
        }
        ByteBuffer buf = dataBuffer instanceof DefaultDataBuffer ? ((DefaultDataBuffer)dataBuffer).getNativeBuffer() : dataBuffer.asByteBuffer();
        return HttpData.wrap((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)buf));
    }

    public DataBuffer toDataBuffer(HttpData httpData) {
        Objects.requireNonNull(httpData, "httpData");
        if (!httpData.isPooled()) {
            return this.delegate.wrap(ByteBuffer.wrap(httpData.array()));
        }
        return this.converter.apply(httpData);
    }

    private PooledDataBuffer withNettyDataBufferFactory(HttpData data) {
        return ((NettyDataBufferFactory)this.delegate).wrap(data.byteBuf());
    }

    private DataBuffer withDataBufferFactory(HttpData data) {
        byte[] dataArray = data.array();
        data.close();
        return this.delegate.wrap(dataArray);
    }
}

