/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.testing.internal;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public abstract class ServerRuleDelegate {
    private final AtomicReference<Server> server = new AtomicReference();
    private final boolean autoStart;

    protected ServerRuleDelegate(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void before() throws Throwable {
        if (this.autoStart) {
            this.start();
        }
    }

    public void after() {
        this.stop();
    }

    public Server start() {
        Server oldServer = this.server.get();
        if (!ServerRuleDelegate.isStopped(oldServer)) {
            return oldServer;
        }
        ServerBuilder sb = new ServerBuilder();
        try {
            this.configure(sb);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to configure a Server", e);
        }
        Server server = sb.build();
        server.start().join();
        this.server.set(server);
        return server;
    }

    public abstract void configure(ServerBuilder var1) throws Exception;

    public CompletableFuture<Void> stop() {
        Server server = this.server.getAndSet(null);
        if (server == null || server.activePorts().isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return server.stop();
    }

    public Server server() {
        Server server = this.server.get();
        if (ServerRuleDelegate.isStopped(server)) {
            throw new IllegalStateException("server did not start.");
        }
        return server;
    }

    private static boolean isStopped(@Nullable Server server) {
        return server == null || server.activePorts().isEmpty();
    }

    public int httpPort() {
        return this.port(SessionProtocol.HTTP);
    }

    public int httpsPort() {
        return this.port(SessionProtocol.HTTPS);
    }

    public int port(SessionProtocol protocol) {
        return (Integer)this.server().activePorts().values().stream().filter(p1 -> p1.hasProtocol(protocol)).findAny().flatMap(p -> Optional.of(p.localAddress().getPort())).orElseThrow(() -> new IllegalStateException(protocol + " port not open"));
    }

    public boolean hasHttp() {
        return this.hasSessionProtocol(SessionProtocol.HTTP);
    }

    public boolean hasHttps() {
        return this.hasSessionProtocol(SessionProtocol.HTTPS);
    }

    private boolean hasSessionProtocol(SessionProtocol protocol) {
        Server server = this.server.get();
        return server != null && server.activePorts().values().stream().anyMatch(port -> port.hasProtocol(protocol));
    }

    public String uri(String path) {
        this.server();
        if (this.hasHttp()) {
            return this.httpUri(path);
        }
        if (this.hasHttps()) {
            return this.httpsUri(path);
        }
        throw new IllegalStateException("can't find a useful active port");
    }

    public String uri(SessionProtocol protocol, SerializationFormat format, String path) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(path, "path");
        this.server();
        return format.uriText() + '+' + this.uri(protocol, path);
    }

    public String uri(SessionProtocol protocol, String path) {
        int port;
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(path, "path");
        this.server();
        if (!protocol.isTls() && this.hasHttp()) {
            port = this.httpPort();
        } else if (protocol.isTls() && this.hasHttps()) {
            port = this.httpsPort();
        } else {
            throw new IllegalStateException("can't find the specified port");
        }
        return protocol.uriText() + "://127.0.0.1:" + port + path;
    }

    public String uri(SerializationFormat serializationFormat, String path) {
        Objects.requireNonNull(serializationFormat, "serializationFormat");
        return serializationFormat.uriText() + '+' + this.uri(path);
    }

    public String httpUri(String path) {
        ServerRuleDelegate.validatePath(path);
        return "http://127.0.0.1:" + this.httpPort() + path;
    }

    public String httpUri(SerializationFormat serializationFormat, String path) {
        Objects.requireNonNull(serializationFormat, "serializationFormat");
        return serializationFormat.uriText() + '+' + this.httpUri(path);
    }

    public String httpsUri(String path) {
        ServerRuleDelegate.validatePath(path);
        return "https://127.0.0.1:" + this.httpsPort() + path;
    }

    public String httpsUri(SerializationFormat serializationFormat, String path) {
        Objects.requireNonNull(serializationFormat, "serializationFormat");
        return serializationFormat.uriText() + '+' + this.httpsUri(path);
    }

    public InetSocketAddress httpSocketAddress() {
        return new InetSocketAddress("127.0.0.1", this.httpPort());
    }

    public InetSocketAddress httpsSocketAddress() {
        return new InetSocketAddress("127.0.0.1", this.httpsPort());
    }

    private static void validatePath(String path) {
        if (!Objects.requireNonNull(path, "path").startsWith("/")) {
            throw new IllegalArgumentException("path: " + path + " (expected: an absolute path)");
        }
    }
}

