/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.testing.junit.server;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.testing.internal.ServerRuleDelegate;
import com.linecorp.armeria.testing.junit.common.AbstractAllOrEachExtension;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class ServerExtension
extends AbstractAllOrEachExtension {
    private final ServerRuleDelegate delegate;

    protected ServerExtension() {
        this(true);
    }

    protected ServerExtension(boolean autoStart) {
        this.delegate = new ServerRuleDelegate(autoStart){

            public void configure(ServerBuilder sb) throws Exception {
                ServerExtension.this.configure(sb);
            }
        };
    }

    @Override
    public void before(ExtensionContext context) throws Exception {
        try {
            this.delegate.before();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to set up before callback", t);
        }
    }

    @Override
    public void after(ExtensionContext context) throws Exception {
        this.delegate.after();
    }

    public Server start() {
        return this.delegate.start();
    }

    protected abstract void configure(ServerBuilder var1) throws Exception;

    public CompletableFuture<Void> stop() {
        return this.delegate.stop();
    }

    public Server server() {
        return this.delegate.server();
    }

    public int httpPort() {
        return this.delegate.httpPort();
    }

    public int httpsPort() {
        return this.delegate.httpsPort();
    }

    public int port(SessionProtocol protocol) {
        return this.delegate.port(protocol);
    }

    public boolean hasHttp() {
        return this.delegate.hasHttp();
    }

    public boolean hasHttps() {
        return this.delegate.hasHttps();
    }

    public String uri(String path) {
        return this.delegate.uri(path);
    }

    public String uri(SessionProtocol protocol, SerializationFormat format, String path) {
        return this.delegate.uri(protocol, format, path);
    }

    public String uri(SessionProtocol protocol, String path) {
        return this.delegate.uri(protocol, path);
    }

    public String uri(SerializationFormat serializationFormat, String path) {
        return this.delegate.uri(serializationFormat, path);
    }

    public String httpUri(String path) {
        return this.delegate.httpUri(path);
    }

    public String httpUri(SerializationFormat serializationFormat, String path) {
        return this.delegate.httpUri(serializationFormat, path);
    }

    public String httpsUri(String path) {
        return this.delegate.httpsUri(path);
    }

    public String httpsUri(SerializationFormat serializationFormat, String path) {
        return this.delegate.httpsUri(serializationFormat, path);
    }

    public InetSocketAddress httpSocketAddress() {
        return this.delegate.httpSocketAddress();
    }

    public InetSocketAddress httpsSocketAddress() {
        return this.delegate.httpsSocketAddress();
    }
}

