/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.testing.junit4.server;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.testing.ServerRuleDelegate;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.junit.rules.ExternalResource;

public abstract class ServerRule
extends ExternalResource {
    private final ServerRuleDelegate delegate;

    protected ServerRule() {
        this(true);
    }

    protected ServerRule(boolean autoStart) {
        this.delegate = new ServerRuleDelegate(autoStart){

            public void configure(ServerBuilder sb) throws Exception {
                ServerRule.this.configure(sb);
            }
        };
    }

    protected void before() throws Throwable {
        this.delegate.before();
    }

    protected void after() {
        this.delegate.after();
    }

    public Server start() {
        return this.delegate.start();
    }

    protected abstract void configure(ServerBuilder var1) throws Exception;

    public CompletableFuture<Void> stop() {
        return this.delegate.stop();
    }

    public Server server() {
        return this.delegate.server();
    }

    public int httpPort() {
        return this.delegate.httpPort();
    }

    public int httpsPort() {
        return this.delegate.httpsPort();
    }

    public int port(SessionProtocol protocol) {
        return this.delegate.port(protocol);
    }

    public boolean hasHttp() {
        return this.delegate.hasHttp();
    }

    public boolean hasHttps() {
        return this.delegate.hasHttps();
    }

    public Endpoint endpoint(SessionProtocol protocol) {
        return this.delegate.endpoint(protocol);
    }

    public Endpoint httpEndpoint() {
        return this.delegate.httpEndpoint();
    }

    public Endpoint httpsEndpoint() {
        return this.delegate.httpsEndpoint();
    }

    public URI uri(SessionProtocol protocol) {
        return this.delegate.uri(protocol);
    }

    public URI uri(SessionProtocol protocol, SerializationFormat format) {
        return this.delegate.uri(protocol, format);
    }

    public URI httpUri() {
        return this.delegate.httpUri();
    }

    public URI httpUri(SerializationFormat format) {
        return this.delegate.httpUri(format);
    }

    public URI httpsUri() {
        return this.delegate.httpsUri();
    }

    public URI httpsUri(SerializationFormat format) {
        return this.delegate.httpsUri(format);
    }

    public InetSocketAddress socketAddress(SessionProtocol protocol) {
        return this.delegate.socketAddress(protocol);
    }

    public InetSocketAddress httpSocketAddress() {
        return this.delegate.httpSocketAddress();
    }

    public InetSocketAddress httpsSocketAddress() {
        return this.delegate.httpsSocketAddress();
    }
}

