/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.thrift;

import com.linecorp.armeria.common.DefaultRpcResponse;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.thrift.ThriftFunction;
import com.linecorp.armeria.server.RpcService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.thrift.ThriftServiceEntry;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.thrift.AsyncProcessFunction;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThriftCallService
implements RpcService {
    private static final Logger logger = LoggerFactory.getLogger(ThriftCallService.class);
    private static final AsyncMethodCallback<Object> ONEWAY_CALLBACK = new AsyncMethodCallback<Object>(){

        public void onComplete(Object response) {
        }

        public void onError(Exception e) {
            ThriftCallService.logOneWayFunctionFailure(RequestContext.currentOrNull(), e);
        }
    };
    private final Map<String, ThriftServiceEntry> entries;

    public static ThriftCallService of(Object implementation) {
        return new ThriftCallService((Map<String, ?>)ImmutableMap.of((Object)"", (Object)implementation));
    }

    public static ThriftCallService of(Map<String, ?> implementations) {
        return new ThriftCallService(implementations);
    }

    private ThriftCallService(Map<String, ?> implementations) {
        Objects.requireNonNull(implementations, "implementations");
        if (implementations.isEmpty()) {
            throw new IllegalArgumentException("empty implementations");
        }
        this.entries = (Map)implementations.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, ThriftServiceEntry::new));
    }

    public Map<String, ThriftServiceEntry> entries() {
        return this.entries;
    }

    public RpcResponse serve(ServiceRequestContext ctx, RpcRequest call) throws Exception {
        ThriftFunction f;
        String method;
        String serviceName;
        int colonPos = call.method().indexOf(58);
        if (colonPos < 0) {
            serviceName = "";
            method = call.method();
        } else {
            serviceName = call.method().substring(0, colonPos);
            method = call.method().substring(colonPos + 1);
        }
        ThriftServiceEntry e = this.entries.get(serviceName);
        if (e != null && (f = e.metadata.function(method)) != null) {
            DefaultRpcResponse reply = new DefaultRpcResponse();
            ThriftCallService.invoke(ctx, e.implementation, f, call.params(), reply);
            return reply;
        }
        return new DefaultRpcResponse((Throwable)new TApplicationException(1, "unknown method: " + call.method()));
    }

    private static void invoke(ServiceRequestContext ctx, Object impl, ThriftFunction func, List<Object> args, DefaultRpcResponse reply) {
        try {
            TBase<?, ?> tArgs = func.newArgs(args);
            if (func.isAsync()) {
                ThriftCallService.invokeAsynchronously(impl, func, tArgs, reply);
            } else {
                ThriftCallService.invokeSynchronously(ctx, impl, func, tArgs, reply);
            }
        }
        catch (Throwable t) {
            reply.completeExceptionally(t);
        }
    }

    private static void invokeAsynchronously(Object impl, ThriftFunction func, TBase<?, ?> args, final DefaultRpcResponse reply) throws TException {
        AsyncProcessFunction<Object, TBase<?, ?>, Object> f = func.asyncFunc();
        if (func.isOneWay()) {
            f.start(impl, args, ONEWAY_CALLBACK);
            reply.complete(null);
        } else {
            f.start(impl, args, (AsyncMethodCallback)new AsyncMethodCallback<Object>(){

                public void onComplete(Object response) {
                    reply.complete(response);
                }

                public void onError(Exception e) {
                    reply.completeExceptionally((Throwable)e);
                }
            });
        }
    }

    private static void invokeSynchronously(ServiceRequestContext ctx, Object impl, ThriftFunction func, TBase<?, ?> args, DefaultRpcResponse reply) {
        ProcessFunction<Object, TBase<?, ?>> f = func.syncFunc();
        ctx.blockingTaskExecutor().execute(() -> {
            if (reply.isDone()) {
                return;
            }
            try {
                if (func.isOneWay()) {
                    reply.complete(null);
                    f.getResult(impl, args);
                } else {
                    TBase result = f.getResult(impl, args);
                    reply.complete(func.getResult(result));
                }
            }
            catch (Throwable t) {
                if (func.isOneWay()) {
                    reply.complete(null);
                    ThriftCallService.logOneWayFunctionFailure((RequestContext)ctx, t);
                }
                reply.completeExceptionally(t);
            }
        });
    }

    private static void logOneWayFunctionFailure(@Nullable RequestContext ctx, Throwable cause) {
        if (ctx != null) {
            logger.warn("{} Unexpected exception from a one-way function:", (Object)ctx, (Object)cause);
        } else {
            logger.warn("Unexpected exception from a one-way function:", cause);
        }
    }
}

