/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.thrift;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.ClientRequestContextCaptor;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.thrift.THttpClient;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.thrift.AsyncMethodCallbacks;
import com.linecorp.armeria.common.util.AbstractUnwrappable;
import com.linecorp.armeria.common.util.CompletionActions;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.Unwrappable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.apache.thrift.async.AsyncMethodCallback;

final class THttpClientInvocationHandler
extends AbstractUnwrappable<THttpClient>
implements InvocationHandler,
ClientBuilderParams {
    private static final Object[] NO_ARGS = new Object[0];
    private final ClientBuilderParams params;

    THttpClientInvocationHandler(ClientBuilderParams params, THttpClient thriftClient) {
        super((Unwrappable)thriftClient);
        this.params = params;
    }

    public Scheme scheme() {
        return this.params.scheme();
    }

    public EndpointGroup endpointGroup() {
        return this.params.endpointGroup();
    }

    public String absolutePathRef() {
        return this.params.absolutePathRef();
    }

    public URI uri() {
        return this.params.uri();
    }

    public Class<?> clientType() {
        return this.params.clientType();
    }

    public ClientOptions options() {
        return this.params.options();
    }

    @Override
    @Nullable
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == Object.class) {
            return this.invokeObjectMethod(proxy, method, args);
        }
        assert (declaringClass == this.params.clientType());
        return this.invokeClientMethod(method, args);
    }

    private Object invokeObjectMethod(Object proxy, Method method, Object[] args) {
        String methodName;
        switch (methodName = method.getName()) {
            case "toString": {
                return this.params.clientType().getSimpleName() + "(" + this.uri().getRawPath() + ")";
            }
            case "hashCode": {
                return System.identityHashCode(proxy);
            }
            case "equals": {
                return proxy == args[0];
            }
        }
        throw new Error("unknown method: " + methodName);
    }

    /*
     * Loose catch block
     */
    @Nullable
    private Object invokeClientMethod(Method method, @Nullable Object[] args) throws Throwable {
        Object object;
        block32: {
            ClientRequestContext ctx;
            RpcResponse reply;
            ClientRequestContextCaptor captor;
            AsyncMethodCallback callback;
            block30: {
                Object var9_13;
                block31: {
                    if (args == null) {
                        args = NO_ARGS;
                        callback = null;
                    } else {
                        int lastIdx = args.length - 1;
                        if (args.length > 0 && args[lastIdx] instanceof AsyncMethodCallback) {
                            AsyncMethodCallback lastArg;
                            callback = lastArg = (AsyncMethodCallback)args[lastIdx];
                            args = Arrays.copyOfRange(args, 0, lastIdx);
                        } else {
                            callback = null;
                        }
                    }
                    captor = Clients.newContextCaptor();
                    String path = this.uri().getRawPath();
                    String fragment = this.uri().getRawFragment();
                    reply = fragment != null ? ((THttpClient)this.unwrap()).executeMultiplexed(path, this.params.clientType(), fragment, method.getName(), args) : ((THttpClient)this.unwrap()).execute(path, this.params.clientType(), method.getName(), args);
                    ctx = captor.get();
                    if (callback == null) break block30;
                    reply.handle((res, cause) -> {
                        try (SafeCloseable ignored = ctx.push();){
                            if (cause != null) {
                                AsyncMethodCallbacks.invokeOnError(callback, cause);
                            } else {
                                callback.onComplete(res);
                            }
                        }
                        catch (Exception e) {
                            CompletionActions.log((Throwable)e);
                        }
                        return null;
                    });
                    var9_13 = null;
                    if (captor == null) break block31;
                    captor.close();
                }
                return var9_13;
            }
            try {
                object = reply.get();
                if (captor == null) break block32;
            }
            catch (ExecutionException e) {
                try {
                    throw Exceptions.peel((Throwable)e);
                    {
                        catch (Throwable cause2) {
                            if (callback != null) {
                                Object var9_19;
                                block34: {
                                    ctx = captor.getOrNull();
                                    if (ctx != null) {
                                        try (SafeCloseable ignored = ctx.push();){
                                            AsyncMethodCallbacks.invokeOnError(callback, cause2);
                                        }
                                        catch (Exception e2) {
                                            CompletionActions.log((Throwable)e2);
                                        }
                                        Object e2 = null;
                                        return e2;
                                    }
                                    try {
                                        AsyncMethodCallbacks.invokeOnError(callback, cause2);
                                    }
                                    catch (Exception e3) {
                                        CompletionActions.log((Throwable)e3);
                                    }
                                    var9_19 = null;
                                    if (captor == null) break block34;
                                    captor.close();
                                }
                                return var9_19;
                            }
                            throw cause2;
                        }
                    }
                }
                finally {
                    if (captor != null) {
                        captor.close();
                    }
                }
            }
            captor.close();
        }
        return object;
    }
}

