/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.thrift;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ThriftDocString {
    private static final Logger logger = LoggerFactory.getLogger(ThriftDocString.class);
    private static final String THRIFT_JSON_PATH;
    private static final TypeReference<HashMap<String, Object>> JSON_VALUE_TYPE;
    private static final String FQCN_DELIM = ".";
    private static final String DELIM = "/";
    private static final Map<ClassLoader, Map<String, String>> cached;

    private ThriftDocString() {
    }

    static Map<String, String> getAllDocStrings(ClassLoader classLoader) {
        return cached.computeIfAbsent(classLoader, loader -> ThriftDocString.parseDocStrings(loader, ThriftDocString.getAllThriftJsons(loader)));
    }

    static Map<String, String> parseDocStrings(ClassLoader classLoader, Iterable<String> jsonPaths) {
        ImmutableMap.Builder docStrings = ImmutableMap.builder();
        for (String jsonPath : jsonPaths) {
            docStrings.putAll(ThriftDocString.getDocStringsFromJsonResource(classLoader, jsonPath));
        }
        return docStrings.build();
    }

    static Iterable<String> getAllThriftJsons(ClassLoader classLoader) {
        ConfigurationBuilder configuration = new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{THRIFT_JSON_PATH})).setUrls(ClasspathHelper.forPackage((String)THRIFT_JSON_PATH, (ClassLoader[])new ClassLoader[0])).addClassLoader(classLoader).addScanners(new Scanner[]{new ResourcesScanner()});
        if (configuration.getUrls() == null || configuration.getUrls().isEmpty()) {
            return Collections.emptyList();
        }
        return new Reflections((Configuration)configuration).getResources(filename -> filename.endsWith(".json"));
    }

    static String key(String ... names) {
        return Stream.of(names).filter(s -> !Strings.isNullOrEmpty((String)s)).collect(Collectors.joining(DELIM));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static Map<String, String> getDocStringsFromJsonResource(ClassLoader classLoader, String jsonResourcePath) {
        ImmutableMap.Builder docStrings = ImmutableMap.builder();
        try (InputStream in = classLoader.getResourceAsStream(jsonResourcePath);){
            if (in == null) {
                throw new IllegalStateException("not found: " + jsonResourcePath);
            }
            Map json = (Map)new ObjectMapper().readValue(in, JSON_VALUE_TYPE);
            Map namespaces = (Map)json.getOrDefault("namespaces", ImmutableMap.of());
            String packageName = (String)namespaces.get("java");
            json.forEach((key, children) -> {
                if (children instanceof Collection) {
                    Collection castChildren = (Collection)children;
                    castChildren.forEach(grandChild -> ThriftDocString.traverseChildren((ImmutableMap.Builder<String, String>)docStrings, packageName, FQCN_DELIM, grandChild));
                }
            });
            ImmutableMap immutableMap = docStrings.build();
            return immutableMap;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void traverseChildren(ImmutableMap.Builder<String, String> docStrings, String prefix, String delimiter, Object node) {
        if (node instanceof Map) {
            String childPrefix;
            Map map = (Map)node;
            String name = (String)map.get("name");
            String doc = (String)map.get("doc");
            if (name != null) {
                childPrefix = (String)MoreObjects.firstNonNull((Object)prefix, (Object)"") + delimiter + name;
                if (doc != null) {
                    docStrings.put((Object)childPrefix, (Object)doc.trim());
                }
            } else {
                childPrefix = prefix;
            }
            map.forEach((key, value) -> ThriftDocString.traverseChildren(docStrings, childPrefix, DELIM, value));
        } else if (node instanceof Iterable) {
            Iterable children = (Iterable)node;
            children.forEach(child -> ThriftDocString.traverseChildren(docStrings, prefix, DELIM, child));
        }
    }

    static {
        JSON_VALUE_TYPE = new TypeReference<HashMap<String, Object>>(){};
        cached = new ConcurrentHashMap<ClassLoader, Map<String, String>>();
        String propertyName = "com.linecorp.armeria.thrift.jsonDir";
        String dir = System.getProperty("com.linecorp.armeria.thrift.jsonDir", "META-INF/armeria/thrift");
        if (dir.startsWith(DELIM) || dir.startsWith("\\")) {
            dir = dir.substring(1);
        }
        if (dir.endsWith(DELIM) || dir.endsWith("\\")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        logger.info("{}: {}", (Object)"com.linecorp.armeria.thrift.jsonDir", (Object)dir);
        THRIFT_JSON_PATH = dir;
    }
}

