/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.thrift.text.PairContext;
import com.linecorp.armeria.internal.thrift.TApplicationExceptions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StructContext
extends PairContext {
    private static final Logger log = LoggerFactory.getLogger(StructContext.class);
    private final Map<String, TField> fieldNameMap;
    private final Map<String, Class<?>> classMap = new HashMap();

    StructContext(JsonNode json) {
        this(json, StructContext.getCurrentThriftMessageClass());
    }

    StructContext(JsonNode json, Class<?> clazz) {
        super(json);
        this.fieldNameMap = this.computeFieldNameMap(clazz);
    }

    @Override
    protected TField getTFieldByName(String name) throws TException {
        if (!this.fieldNameMap.containsKey(name)) {
            throw new TException("Unknown field: " + name);
        }
        return this.fieldNameMap.get(name);
    }

    @Override
    @Nullable
    protected Class<?> getClassByFieldName(String fieldName) {
        return this.classMap.get(fieldName);
    }

    private static Class<?> getCurrentThriftMessageClass() {
        StackTraceElement[] frames;
        for (StackTraceElement f : frames = Thread.currentThread().getStackTrace()) {
            String className = f.getClassName();
            try {
                Class<?> clazz = Class.forName(className);
                if (StructContext.isTBase(clazz) && !StructContext.isAbstract(clazz) && StructContext.hasNoArgConstructor(clazz)) {
                    return clazz;
                }
                if (StructContext.isTApplicationException(clazz)) {
                    return clazz;
                }
                if (!StructContext.isTApplicationExceptions(clazz)) continue;
                return TApplicationException.class;
            }
            catch (ClassNotFoundException ex) {
                log.warn("Can't find class: " + className, (Throwable)ex);
            }
        }
        throw new RuntimeException("Must call (indirectly) from a TBase/TApplicationException object.");
    }

    private static boolean isTBase(Class<?> clazz) {
        return TBase.class.isAssignableFrom(clazz);
    }

    private static boolean isTApplicationException(Class<?> clazz) {
        return TApplicationException.class.isAssignableFrom(clazz);
    }

    private static boolean isTApplicationExceptions(Class<?> clazz) {
        return clazz == TApplicationExceptions.class;
    }

    private static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    private static boolean hasNoArgConstructor(Class<?> clazz) {
        Constructor<?>[] allConstructors;
        for (Constructor<?> ctor : allConstructors = clazz.getConstructors()) {
            Class<?>[] pType = ctor.getParameterTypes();
            if (pType.length != 0) continue;
            return true;
        }
        return false;
    }

    private Map<String, TField> computeFieldNameMap(Class<?> clazz) {
        HashMap<String, TField> map = new HashMap<String, TField>();
        if (StructContext.isTBase(clazz)) {
            Map metaDataMap = FieldMetaData.getStructMetaDataMap(clazz);
            for (Map.Entry e : metaDataMap.entrySet()) {
                String fieldName = ((TFieldIdEnum)e.getKey()).getFieldName();
                FieldMetaData metaData = (FieldMetaData)e.getValue();
                FieldValueMetaData elementMetaData = metaData.valueMetaData.isContainer() ? (metaData.valueMetaData instanceof SetMetaData ? ((SetMetaData)metaData.valueMetaData).elemMetaData : (metaData.valueMetaData instanceof ListMetaData ? ((ListMetaData)metaData.valueMetaData).elemMetaData : (metaData.valueMetaData instanceof MapMetaData ? ((MapMetaData)metaData.valueMetaData).valueMetaData : metaData.valueMetaData))) : metaData.valueMetaData;
                if (elementMetaData instanceof EnumMetaData) {
                    this.classMap.put(fieldName, ((EnumMetaData)elementMetaData).enumClass);
                } else if (elementMetaData instanceof StructMetaData) {
                    this.classMap.put(fieldName, ((StructMetaData)elementMetaData).structClass);
                }
                byte type = 16 == metaData.valueMetaData.type ? (byte)8 : (byte)metaData.valueMetaData.type;
                map.put(fieldName, new TField(fieldName, type, ((TFieldIdEnum)e.getKey()).getThriftFieldId()));
            }
        } else {
            map.put("message", new TField("message", 11, 1));
            map.put("type", new TField("type", 8, 2));
        }
        return map;
    }
}

