/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.linecorp.armeria.common.thrift.ThriftProtocolFactories;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.docs.DocServicePlugin;
import com.linecorp.armeria.server.docs.EndpointInfo;
import com.linecorp.armeria.server.docs.EnumInfo;
import com.linecorp.armeria.server.docs.EnumValueInfo;
import com.linecorp.armeria.server.docs.ExceptionInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.MethodInfo;
import com.linecorp.armeria.server.docs.NamedTypeInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.ServiceSpecification;
import com.linecorp.armeria.server.docs.StructInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import com.linecorp.armeria.server.thrift.THttpService;
import com.linecorp.armeria.server.thrift.ThriftDocStringExtractor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;

public class ThriftDocServicePlugin
implements DocServicePlugin {
    private static final String REQUEST_STRUCT_SUFFIX = "_args";
    private static final TypeSignature VOID = TypeSignature.ofBase((String)"void");
    private static final TypeSignature BOOL = TypeSignature.ofBase((String)"bool");
    private static final TypeSignature I8 = TypeSignature.ofBase((String)"i8");
    private static final TypeSignature I16 = TypeSignature.ofBase((String)"i16");
    private static final TypeSignature I32 = TypeSignature.ofBase((String)"i32");
    private static final TypeSignature I64 = TypeSignature.ofBase((String)"i64");
    private static final TypeSignature DOUBLE = TypeSignature.ofBase((String)"double");
    private static final TypeSignature STRING = TypeSignature.ofBase((String)"string");
    private static final TypeSignature BINARY = TypeSignature.ofBase((String)"binary");
    private ThriftDocStringExtractor docstringExtractor = new ThriftDocStringExtractor();

    public Set<Class<? extends Service<?, ?>>> supportedServiceTypes() {
        return ImmutableSet.of(THttpService.class);
    }

    public ServiceSpecification generateSpecification(Set<ServiceConfig> serviceConfigs) {
        LinkedHashMap map = new LinkedHashMap();
        for (ServiceConfig c : serviceConfigs) {
            THttpService service = (THttpService)((Object)c.service().as(THttpService.class).get());
            service.entries().forEach((serviceName, entry) -> {
                for (Class<?> iface : entry.interfaces()) {
                    Class<?> serviceClass = iface.getEnclosingClass();
                    EntryBuilder builder = map.computeIfAbsent(serviceClass, cls -> new EntryBuilder(serviceClass));
                    c.pathMapping().exactPath().ifPresent(p -> builder.endpoint(new EndpointInfo(c.virtualHost().hostnamePattern(), p, serviceName, service.defaultSerializationFormat(), service.allowedSerializationFormats())));
                }
            });
        }
        List<Entry> entries = map.values().stream().map(EntryBuilder::build).collect(Collectors.toList());
        return ThriftDocServicePlugin.generate(entries);
    }

    @VisibleForTesting
    static ServiceSpecification generate(List<Entry> entries) {
        List services = (List)entries.stream().map(e -> ThriftDocServicePlugin.newServiceInfo(e.serviceType, e.endpointInfos)).collect(ImmutableList.toImmutableList());
        return ServiceSpecification.generate((Iterable)services, ThriftDocServicePlugin::newNamedTypeInfo);
    }

    @VisibleForTesting
    static ServiceInfo newServiceInfo(Class<?> serviceClass, Iterable<EndpointInfo> endpoints) {
        Class<?> interfaceClass;
        Objects.requireNonNull(serviceClass, "serviceClass");
        String name = serviceClass.getName();
        ClassLoader serviceClassLoader = serviceClass.getClassLoader();
        String interfaceClassName = name + "$Iface";
        try {
            interfaceClass = Class.forName(interfaceClassName, false, serviceClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("failed to find a class: " + interfaceClassName, e);
        }
        Method[] methods = interfaceClass.getDeclaredMethods();
        return new ServiceInfo(name, Arrays.stream(methods).map(ThriftDocServicePlugin::newMethodInfo)::iterator, endpoints);
    }

    private static MethodInfo newMethodInfo(Method method) {
        Class<?> resultClass;
        Class<?> argsClass;
        Objects.requireNonNull(method, "method");
        String methodName = method.getName();
        Class<?> serviceClass = method.getDeclaringClass().getDeclaringClass();
        String serviceName = serviceClass.getName();
        ClassLoader classLoader = serviceClass.getClassLoader();
        String argsClassName = serviceName + '$' + methodName + REQUEST_STRUCT_SUFFIX;
        try {
            Class<?> argsClass0;
            argsClass = argsClass0 = Class.forName(argsClassName, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("failed to find a class: " + argsClassName, e);
        }
        try {
            resultClass = Class.forName(serviceName + '$' + methodName + "_result", false, classLoader);
        }
        catch (ClassNotFoundException ignored) {
            resultClass = null;
        }
        MethodInfo methodInfo = ThriftDocServicePlugin.newMethodInfo(methodName, argsClass, resultClass, method.getExceptionTypes());
        return methodInfo;
    }

    private static MethodInfo newMethodInfo(String name, Class<? extends TBase<?, ?>> argsClass, @Nullable Class<? extends TBase<?, ?>> resultClass, Class<? extends TException>[] exceptionClasses) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(argsClass, "argsClass");
        Objects.requireNonNull(exceptionClasses, "exceptionClasses");
        List parameters = (List)FieldMetaData.getStructMetaDataMap(argsClass).values().stream().map(fieldMetaData -> ThriftDocServicePlugin.newFieldInfo(argsClass, fieldMetaData)).collect(ImmutableList.toImmutableList());
        FieldInfo fieldInfo = null;
        if (resultClass != null) {
            Map resultMetaData = FieldMetaData.getStructMetaDataMap(resultClass);
            for (FieldMetaData fieldMetaData2 : resultMetaData.values()) {
                if (!"success".equals(fieldMetaData2.fieldName)) continue;
                fieldInfo = ThriftDocServicePlugin.newFieldInfo(resultClass, fieldMetaData2);
                break;
            }
        }
        TypeSignature returnTypeSignature = fieldInfo == null ? VOID : fieldInfo.typeSignature();
        List exceptionTypeSignatures = (List)Arrays.stream(exceptionClasses).filter(e -> e != TException.class).map(TypeSignature::ofNamed).collect(ImmutableList.toImmutableList());
        return new MethodInfo(name, returnTypeSignature, (Iterable)parameters, (Iterable)exceptionTypeSignatures);
    }

    private static NamedTypeInfo newNamedTypeInfo(TypeSignature typeSignature) {
        Class type = (Class)typeSignature.namedTypeDescriptor().get();
        if (type.isEnum()) {
            return ThriftDocServicePlugin.newEnumInfo(type);
        }
        if (TException.class.isAssignableFrom(type)) {
            Class castType = type;
            return ThriftDocServicePlugin.newExceptionInfo(castType);
        }
        assert (TBase.class.isAssignableFrom(type));
        Class castType = type;
        return ThriftDocServicePlugin.newStructInfo(castType);
    }

    @VisibleForTesting
    static EnumInfo newEnumInfo(Class<?> enumClass) {
        Field[] fields;
        Objects.requireNonNull(enumClass, "enumClass");
        ArrayList<EnumValueInfo> values = new ArrayList<EnumValueInfo>();
        for (Field field : fields = enumClass.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            try {
                values.add(new EnumValueInfo(String.valueOf(field.get(null))));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        String name = enumClass.getName();
        return new EnumInfo(name, values);
    }

    @VisibleForTesting
    static StructInfo newStructInfo(Class<? extends TBase<?, ?>> structClass) {
        String name = structClass.getName();
        Map metaDataMap = FieldMetaData.getStructMetaDataMap(structClass);
        List fields = metaDataMap.values().stream().map(fieldMetaData -> ThriftDocServicePlugin.newFieldInfo(structClass, fieldMetaData)).collect(Collectors.toList());
        return new StructInfo(name, fields);
    }

    @VisibleForTesting
    static ExceptionInfo newExceptionInfo(Class<? extends TException> exceptionClass) {
        List fields;
        Objects.requireNonNull(exceptionClass, "exceptionClass");
        String name = exceptionClass.getName();
        try {
            Map metaDataMap = (Map)exceptionClass.getDeclaredField("metaDataMap").get(null);
            fields = (List)metaDataMap.values().stream().map(fieldMetaData -> ThriftDocServicePlugin.newFieldInfo(exceptionClass, fieldMetaData)).collect(ImmutableList.toImmutableList());
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("will not happen", e);
        }
        catch (NoSuchFieldException ignored) {
            fields = Collections.emptyList();
        }
        return new ExceptionInfo(name, fields);
    }

    @VisibleForTesting
    static FieldInfo newFieldInfo(Class<?> parentType, FieldMetaData fieldMetaData) {
        Objects.requireNonNull(fieldMetaData, "fieldMetaData");
        FieldValueMetaData fieldValueMetaData = fieldMetaData.valueMetaData;
        TypeSignature typeSignature = fieldValueMetaData.isStruct() && fieldValueMetaData.isTypedef() && parentType.getSimpleName().equals(fieldValueMetaData.getTypedefName()) ? TypeSignature.ofNamed(parentType) : ThriftDocServicePlugin.toTypeSignature(fieldValueMetaData);
        return new FieldInfo(fieldMetaData.fieldName, ThriftDocServicePlugin.convertRequirement(fieldMetaData.requirementType), typeSignature);
    }

    @VisibleForTesting
    static TypeSignature toTypeSignature(FieldValueMetaData fieldValueMetaData) {
        if (fieldValueMetaData instanceof StructMetaData) {
            return TypeSignature.ofNamed((Class)((StructMetaData)fieldValueMetaData).structClass);
        }
        if (fieldValueMetaData instanceof EnumMetaData) {
            return TypeSignature.ofNamed((Class)((EnumMetaData)fieldValueMetaData).enumClass);
        }
        if (fieldValueMetaData instanceof ListMetaData) {
            return TypeSignature.ofList((TypeSignature)ThriftDocServicePlugin.toTypeSignature(((ListMetaData)fieldValueMetaData).elemMetaData));
        }
        if (fieldValueMetaData instanceof SetMetaData) {
            return TypeSignature.ofSet((TypeSignature)ThriftDocServicePlugin.toTypeSignature(((SetMetaData)fieldValueMetaData).elemMetaData));
        }
        if (fieldValueMetaData instanceof MapMetaData) {
            return TypeSignature.ofMap((TypeSignature)ThriftDocServicePlugin.toTypeSignature(((MapMetaData)fieldValueMetaData).keyMetaData), (TypeSignature)ThriftDocServicePlugin.toTypeSignature(((MapMetaData)fieldValueMetaData).valueMetaData));
        }
        if (fieldValueMetaData.isBinary()) {
            return BINARY;
        }
        switch (fieldValueMetaData.type) {
            case 1: {
                return VOID;
            }
            case 2: {
                return BOOL;
            }
            case 3: {
                return I8;
            }
            case 4: {
                return DOUBLE;
            }
            case 6: {
                return I16;
            }
            case 8: {
                return I32;
            }
            case 10: {
                return I64;
            }
            case 11: {
                return STRING;
            }
        }
        String unresolvedName = fieldValueMetaData.isTypedef() ? fieldValueMetaData.getTypedefName() : null;
        return TypeSignature.ofUnresolved((String)((String)MoreObjects.firstNonNull((Object)unresolvedName, (Object)"unknown")));
    }

    private static FieldRequirement convertRequirement(byte value) {
        switch (value) {
            case 1: {
                return FieldRequirement.REQUIRED;
            }
            case 2: {
                return FieldRequirement.OPTIONAL;
            }
            case 3: {
                return FieldRequirement.DEFAULT;
            }
        }
        throw new IllegalArgumentException("unknown requirement type: " + value);
    }

    public Map<String, String> loadDocStrings(Set<ServiceConfig> serviceConfigs) {
        return (Map)serviceConfigs.stream().flatMap(c -> ((THttpService)((Object)((Object)c.service().as(THttpService.class).get()))).entries().values().stream()).flatMap(entry -> entry.interfaces().stream().map(Class::getClassLoader)).flatMap(loader -> this.docstringExtractor.getAllDocStrings((ClassLoader)loader).entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
    }

    public Set<Class<?>> supportedExampleRequestTypes() {
        return ImmutableSet.of(TBase.class);
    }

    public Optional<String> guessServiceName(Object exampleRequest) {
        TBase<?, ?> exampleTBase = ThriftDocServicePlugin.asTBase(exampleRequest);
        if (exampleTBase == null) {
            return Optional.empty();
        }
        return Optional.of(exampleTBase.getClass().getEnclosingClass().getName());
    }

    public Optional<String> guessServiceMethodName(Object exampleRequest) {
        TBase<?, ?> exampleTBase = ThriftDocServicePlugin.asTBase(exampleRequest);
        if (exampleTBase == null) {
            return Optional.empty();
        }
        String typeName = exampleTBase.getClass().getName();
        return Optional.of(typeName.substring(typeName.lastIndexOf(36) + 1, typeName.length() - REQUEST_STRUCT_SUFFIX.length()));
    }

    public Optional<String> serializeExampleRequest(String serviceName, String methodName, Object exampleRequest) {
        if (!(exampleRequest instanceof TBase)) {
            return Optional.empty();
        }
        TBase exampleTBase = (TBase)exampleRequest;
        TSerializer serializer = new TSerializer(ThriftProtocolFactories.TEXT);
        try {
            return Optional.of(serializer.toString(exampleTBase, StandardCharsets.UTF_8.name()));
        }
        catch (TException e) {
            throw new Error("should never reach here", e);
        }
    }

    private static TBase<?, ?> asTBase(Object exampleRequest) {
        TBase exampleTBase = (TBase)exampleRequest;
        Class<?> type = exampleTBase.getClass();
        if (!type.getName().endsWith(REQUEST_STRUCT_SUFFIX)) {
            return null;
        }
        Class<?> serviceType = type.getEnclosingClass();
        if (serviceType == null) {
            return null;
        }
        if (serviceType.getEnclosingClass() != null) {
            return null;
        }
        return exampleTBase;
    }

    @VisibleForTesting
    static final class EntryBuilder {
        private final Class<?> serviceType;
        private final List<EndpointInfo> endpointInfos = new ArrayList<EndpointInfo>();

        EntryBuilder(Class<?> serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
        }

        EntryBuilder endpoint(EndpointInfo endpointInfo) {
            this.endpointInfos.add(Objects.requireNonNull(endpointInfo, "endpointInfo"));
            return this;
        }

        Entry build() {
            return new Entry(this.serviceType, this.endpointInfos);
        }
    }

    @VisibleForTesting
    static final class Entry {
        final Class<?> serviceType;
        final List<EndpointInfo> endpointInfos;

        Entry(Class<?> serviceType, List<EndpointInfo> endpointInfos) {
            this.serviceType = serviceType;
            this.endpointInfos = ImmutableList.copyOf(endpointInfos);
        }
    }
}

